@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerCertificatesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateId The ID of the Certificate.
 */
public data class ListenerCertificatesArgs(
    public val certificateId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerCertificatesArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerCertificatesArgs =
        com.pulumi.alicloud.alb.inputs.ListenerCertificatesArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerCertificatesArgs].
 */
@PulumiTagMarker
public class ListenerCertificatesArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    /**
     * @param value The ID of the Certificate.
     */
    @JvmName("jfbtktyoxmlpajnm")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value The ID of the Certificate.
     */
    @JvmName("kyddbisyprdilmnn")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    internal fun build(): ListenerCertificatesArgs = ListenerCertificatesArgs(
        certificateId = certificateId,
    )
}
