@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerDefaultActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property forwardGroupConfig The configurations of the actions. This parameter is required if Type is set to FowardGroup. See `forward_group_config` below for details.
 * @property type Action Type.
 */
public data class ListenerDefaultActionArgs(
    public val forwardGroupConfig: Output<ListenerDefaultActionForwardGroupConfigArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerDefaultActionArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerDefaultActionArgs =
        com.pulumi.alicloud.alb.inputs.ListenerDefaultActionArgs.builder()
            .forwardGroupConfig(
                forwardGroupConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionArgsBuilder internal constructor() {
    private var forwardGroupConfig: Output<ListenerDefaultActionForwardGroupConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The configurations of the actions. This parameter is required if Type is set to FowardGroup. See `forward_group_config` below for details.
     */
    @JvmName("xakopjxeoljwitwb")
    public suspend fun forwardGroupConfig(`value`: Output<ListenerDefaultActionForwardGroupConfigArgs>) {
        this.forwardGroupConfig = value
    }

    /**
     * @param value Action Type.
     */
    @JvmName("okuqxctovcelhsqs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The configurations of the actions. This parameter is required if Type is set to FowardGroup. See `forward_group_config` below for details.
     */
    @JvmName("aeklgfjlupulmdij")
    public suspend fun forwardGroupConfig(`value`: ListenerDefaultActionForwardGroupConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardGroupConfig = mapped
    }

    /**
     * @param argument The configurations of the actions. This parameter is required if Type is set to FowardGroup. See `forward_group_config` below for details.
     */
    @JvmName("hfmkhsclbjtclklr")
    public suspend fun forwardGroupConfig(argument: suspend ListenerDefaultActionForwardGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionForwardGroupConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardGroupConfig = mapped
    }

    /**
     * @param value Action Type.
     */
    @JvmName("nkislywyyfkaxmoi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ListenerDefaultActionArgs = ListenerDefaultActionArgs(
        forwardGroupConfig = forwardGroupConfig ?: throw PulumiNullFieldException("forwardGroupConfig"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
