@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupTuples The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
 */
public data class ListenerDefaultActionForwardGroupConfigArgs(
    public val serverGroupTuples: Output<List<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigArgs = com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigArgs.builder()
        .serverGroupTuples(
            serverGroupTuples.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [ListenerDefaultActionForwardGroupConfigArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardGroupConfigArgsBuilder internal constructor() {
    private var serverGroupTuples:
        Output<List<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>>? = null

    /**
     * @param value The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("cawdxqwblvlqhije")
    public suspend fun serverGroupTuples(`value`: Output<List<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = value
    }

    @JvmName("kicvvoasehktwsqa")
    public suspend fun serverGroupTuples(vararg values: Output<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>) {
        this.serverGroupTuples = Output.all(values.asList())
    }

    /**
     * @param values The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("uwtwqoqjkefhppvi")
    public suspend fun serverGroupTuples(values: List<Output<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = Output.all(values)
    }

    /**
     * @param value The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("auvvecqpxmqsroeq")
    public suspend fun serverGroupTuples(`value`: List<ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("ltvccniuqjfdutsi")
    public suspend fun serverGroupTuples(argument: List<suspend ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("fiqsklyyvbjklbbt")
    public suspend fun serverGroupTuples(vararg argument: suspend ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("xvujyombqeonlfod")
    public suspend fun serverGroupTuples(argument: suspend ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param values The destination server group to which requests are forwarded. See `server_group_tuples` below for details.
     */
    @JvmName("ppnoygyoxbenjmoa")
    public suspend fun serverGroupTuples(vararg values: ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    internal fun build(): ListenerDefaultActionForwardGroupConfigArgs =
        ListenerDefaultActionForwardGroupConfigArgs(
            serverGroupTuples = serverGroupTuples ?: throw PulumiNullFieldException("serverGroupTuples"),
        )
}
