@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupId The ID of the destination server group to which requests are forwarded.
 */
public data class ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs(
    public val serverGroupId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs =
        com.pulumi.alicloud.alb.inputs.ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs.builder()
            .serverGroupId(serverGroupId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardGroupConfigServerGroupTupleArgsBuilder internal constructor() {
    private var serverGroupId: Output<String>? = null

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("gphcbpnbmruoqhpp")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("fidnspcodvdkorpn")
    public suspend fun serverGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    internal fun build(): ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs =
        ListenerDefaultActionForwardGroupConfigServerGroupTupleArgs(
            serverGroupId = serverGroupId ?: throw PulumiNullFieldException("serverGroupId"),
        )
}
