@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerQuicConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property quicListenerId There Is a Need to Correlate the QuIC Listener ID. The Https Listener, in Effect at the Time. quicupgradeenabled True When Required.
 * @property quicUpgradeEnabled Indicates Whether to Enable the QuIC Upgrade.
 * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
 */
public data class ListenerQuicConfigArgs(
    public val quicListenerId: Output<String>? = null,
    public val quicUpgradeEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerQuicConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerQuicConfigArgs =
        com.pulumi.alicloud.alb.inputs.ListenerQuicConfigArgs.builder()
            .quicListenerId(quicListenerId?.applyValue({ args0 -> args0 }))
            .quicUpgradeEnabled(quicUpgradeEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerQuicConfigArgs].
 */
@PulumiTagMarker
public class ListenerQuicConfigArgsBuilder internal constructor() {
    private var quicListenerId: Output<String>? = null

    private var quicUpgradeEnabled: Output<Boolean>? = null

    /**
     * @param value There Is a Need to Correlate the QuIC Listener ID. The Https Listener, in Effect at the Time. quicupgradeenabled True When Required.
     */
    @JvmName("vghvpeeamdlpdsqj")
    public suspend fun quicListenerId(`value`: Output<String>) {
        this.quicListenerId = value
    }

    /**
     * @param value Indicates Whether to Enable the QuIC Upgrade.
     * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
     */
    @JvmName("ovchkdqrswvneokl")
    public suspend fun quicUpgradeEnabled(`value`: Output<Boolean>) {
        this.quicUpgradeEnabled = value
    }

    /**
     * @param value There Is a Need to Correlate the QuIC Listener ID. The Https Listener, in Effect at the Time. quicupgradeenabled True When Required.
     */
    @JvmName("iyppexghrjwqbyxj")
    public suspend fun quicListenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quicListenerId = mapped
    }

    /**
     * @param value Indicates Whether to Enable the QuIC Upgrade.
     * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
     */
    @JvmName("qxkpioprqrdfmknm")
    public suspend fun quicUpgradeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quicUpgradeEnabled = mapped
    }

    internal fun build(): ListenerQuicConfigArgs = ListenerQuicConfigArgs(
        quicListenerId = quicListenerId,
        quicUpgradeEnabled = quicUpgradeEnabled,
    )
}
