@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerXForwardedForConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property xForwardedForClientCertClientVerifyAlias The Custom Header Field Names Only When `x_forwarded_for_client_cert_client_verify_enabled` Has a Value of True, this Value Will Not Take Effect until.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertClientVerifyEnabled Indicates Whether the `X-Forwarded-Clientcert-clientverify` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate to Verify the Results.
 * @property xForwardedForClientCertFingerPrintAlias The Custom Header Field Names Only When `x_forwarded_for_client_certfingerprint_enabled`, Which Evaluates to True When the Entry into Force of.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertFingerPrintEnabled Indicates Whether the `X-Forwarded-client_cert-fingerprint` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate Fingerprint Value.
 * @property xForwardedForClientCertIssuerDnAlias The Custom Header Field Names Only When `x_forwarded_for_client_cert_issuer_dn_enabled`, Which Evaluates to True When the Entry into Force of.
 * @property xForwardedForClientCertIssuerDnEnabled Indicates Whether the `X-Forwarded-Clientcert-issuerdn` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate after the Manifests Are Signed, the Publisher Information.
 * @property xForwardedForClientCertSubjectDnAlias The name of the custom header. This parameter is valid only if `x_forwarded_for_client_certsubjectdn_enabled` is set to true. The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xForwardedForClientCertSubjectDnEnabled Specifies whether to use the `X-Forwarded-client_cert-subjectdn` header field to obtain information about the owner of the ALB client certificate. Valid values: true and false. Default value: false.
 * @property xForwardedForClientSourceIpsEnabled Whether to use the X-Forwarded-Client-Ip header to obtain the source IP address of the server load balancer instance. Value: true, false. Note HTTP, HTTPS, and QUIC listeners support this parameter. The function corresponding to this parameter is not open by default. Please contact the account manager if you need to use it.
 * @property xForwardedForClientSourceIpsTrusted Specify the trusted proxy IP. Application-oriented load balancing ALB will traverse the X-Forwarded-For from back to front, and select the first IP that is not in the trusted IP list as the real client IP, which will be used for the source IP speed limit.
 * @property xForwardedForClientSrcPortEnabled Indicates Whether the X-Forwarded-Client-Port Header Field Is Used to Obtain Access to Server Load Balancer Instances to the Client, and Those of the Ports.
 * @property xForwardedForEnabled Whether to Enable by X-Forwarded-For Header Field Is Used to Obtain the Client IP Addresses.
 * @property xForwardedForProtoEnabled Indicates Whether the X-Forwarded-Proto Header Field Is Used to Obtain the Server Load Balancer Instance Snooping Protocols.
 * @property xForwardedForSlbIdEnabled Indicates Whether the SLB-ID Header Field Is Used to Obtain the Load Balancing Instance Id.
 * @property xForwardedForSlbPortEnabled Indicates Whether the X-Forwarded-Port Header Field Is Used to Obtain the Server Load Balancer Instance Listening Port.
 */
public data class ListenerXForwardedForConfigArgs(
    public val xForwardedForClientCertClientVerifyAlias: Output<String>? = null,
    public val xForwardedForClientCertClientVerifyEnabled: Output<Boolean>? = null,
    public val xForwardedForClientCertFingerPrintAlias: Output<String>? = null,
    public val xForwardedForClientCertFingerPrintEnabled: Output<Boolean>? = null,
    public val xForwardedForClientCertIssuerDnAlias: Output<String>? = null,
    public val xForwardedForClientCertIssuerDnEnabled: Output<Boolean>? = null,
    public val xForwardedForClientCertSubjectDnAlias: Output<String>? = null,
    public val xForwardedForClientCertSubjectDnEnabled: Output<Boolean>? = null,
    public val xForwardedForClientSourceIpsEnabled: Output<Boolean>? = null,
    public val xForwardedForClientSourceIpsTrusted: Output<String>? = null,
    public val xForwardedForClientSrcPortEnabled: Output<Boolean>? = null,
    public val xForwardedForEnabled: Output<Boolean>? = null,
    public val xForwardedForProtoEnabled: Output<Boolean>? = null,
    public val xForwardedForSlbIdEnabled: Output<Boolean>? = null,
    public val xForwardedForSlbPortEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerXForwardedForConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerXForwardedForConfigArgs =
        com.pulumi.alicloud.alb.inputs.ListenerXForwardedForConfigArgs.builder()
            .xForwardedForClientCertClientVerifyAlias(
                xForwardedForClientCertClientVerifyAlias?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertClientVerifyEnabled(
                xForwardedForClientCertClientVerifyEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertFingerPrintAlias(
                xForwardedForClientCertFingerPrintAlias?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertFingerPrintEnabled(
                xForwardedForClientCertFingerPrintEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertIssuerDnAlias(
                xForwardedForClientCertIssuerDnAlias?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertIssuerDnEnabled(
                xForwardedForClientCertIssuerDnEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertSubjectDnAlias(
                xForwardedForClientCertSubjectDnAlias?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientCertSubjectDnEnabled(
                xForwardedForClientCertSubjectDnEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientSourceIpsEnabled(
                xForwardedForClientSourceIpsEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientSourceIpsTrusted(
                xForwardedForClientSourceIpsTrusted?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForClientSrcPortEnabled(
                xForwardedForClientSrcPortEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .xForwardedForEnabled(xForwardedForEnabled?.applyValue({ args0 -> args0 }))
            .xForwardedForProtoEnabled(xForwardedForProtoEnabled?.applyValue({ args0 -> args0 }))
            .xForwardedForSlbIdEnabled(xForwardedForSlbIdEnabled?.applyValue({ args0 -> args0 }))
            .xForwardedForSlbPortEnabled(xForwardedForSlbPortEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerXForwardedForConfigArgs].
 */
@PulumiTagMarker
public class ListenerXForwardedForConfigArgsBuilder internal constructor() {
    private var xForwardedForClientCertClientVerifyAlias: Output<String>? = null

    private var xForwardedForClientCertClientVerifyEnabled: Output<Boolean>? = null

    private var xForwardedForClientCertFingerPrintAlias: Output<String>? = null

    private var xForwardedForClientCertFingerPrintEnabled: Output<Boolean>? = null

    private var xForwardedForClientCertIssuerDnAlias: Output<String>? = null

    private var xForwardedForClientCertIssuerDnEnabled: Output<Boolean>? = null

    private var xForwardedForClientCertSubjectDnAlias: Output<String>? = null

    private var xForwardedForClientCertSubjectDnEnabled: Output<Boolean>? = null

    private var xForwardedForClientSourceIpsEnabled: Output<Boolean>? = null

    private var xForwardedForClientSourceIpsTrusted: Output<String>? = null

    private var xForwardedForClientSrcPortEnabled: Output<Boolean>? = null

    private var xForwardedForEnabled: Output<Boolean>? = null

    private var xForwardedForProtoEnabled: Output<Boolean>? = null

    private var xForwardedForSlbIdEnabled: Output<Boolean>? = null

    private var xForwardedForSlbPortEnabled: Output<Boolean>? = null

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_cert_client_verify_enabled` Has a Value of True, this Value Will Not Take Effect until.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("qhadeysculyvfbua")
    public suspend fun xForwardedForClientCertClientVerifyAlias(`value`: Output<String>) {
        this.xForwardedForClientCertClientVerifyAlias = value
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-Clientcert-clientverify` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate to Verify the Results.
     */
    @JvmName("jgenpxktqwnaiqfq")
    public suspend fun xForwardedForClientCertClientVerifyEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientCertClientVerifyEnabled = value
    }

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_certfingerprint_enabled`, Which Evaluates to True When the Entry into Force of.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("xsytpstswultndfc")
    public suspend fun xForwardedForClientCertFingerPrintAlias(`value`: Output<String>) {
        this.xForwardedForClientCertFingerPrintAlias = value
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-client_cert-fingerprint` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate Fingerprint Value.
     */
    @JvmName("sflwrxbsiycelbyg")
    public suspend fun xForwardedForClientCertFingerPrintEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientCertFingerPrintEnabled = value
    }

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_cert_issuer_dn_enabled`, Which Evaluates to True When the Entry into Force of.
     */
    @JvmName("mgdpfgnntpwxketp")
    public suspend fun xForwardedForClientCertIssuerDnAlias(`value`: Output<String>) {
        this.xForwardedForClientCertIssuerDnAlias = value
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-Clientcert-issuerdn` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate after the Manifests Are Signed, the Publisher Information.
     */
    @JvmName("tjnabqgsabifpaax")
    public suspend fun xForwardedForClientCertIssuerDnEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientCertIssuerDnEnabled = value
    }

    /**
     * @param value The name of the custom header. This parameter is valid only if `x_forwarded_for_client_certsubjectdn_enabled` is set to true. The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("abgrrplirvcjfofp")
    public suspend fun xForwardedForClientCertSubjectDnAlias(`value`: Output<String>) {
        this.xForwardedForClientCertSubjectDnAlias = value
    }

    /**
     * @param value Specifies whether to use the `X-Forwarded-client_cert-subjectdn` header field to obtain information about the owner of the ALB client certificate. Valid values: true and false. Default value: false.
     */
    @JvmName("bhsednhqtinhhsmk")
    public suspend fun xForwardedForClientCertSubjectDnEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientCertSubjectDnEnabled = value
    }

    /**
     * @param value Whether to use the X-Forwarded-Client-Ip header to obtain the source IP address of the server load balancer instance. Value: true, false. Note HTTP, HTTPS, and QUIC listeners support this parameter. The function corresponding to this parameter is not open by default. Please contact the account manager if you need to use it.
     */
    @JvmName("khomngikokqchdsh")
    public suspend fun xForwardedForClientSourceIpsEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientSourceIpsEnabled = value
    }

    /**
     * @param value Specify the trusted proxy IP. Application-oriented load balancing ALB will traverse the X-Forwarded-For from back to front, and select the first IP that is not in the trusted IP list as the real client IP, which will be used for the source IP speed limit.
     */
    @JvmName("ltcmhpypjpocinwm")
    public suspend fun xForwardedForClientSourceIpsTrusted(`value`: Output<String>) {
        this.xForwardedForClientSourceIpsTrusted = value
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Client-Port Header Field Is Used to Obtain Access to Server Load Balancer Instances to the Client, and Those of the Ports.
     */
    @JvmName("pbkvfwdkbikdlnmf")
    public suspend fun xForwardedForClientSrcPortEnabled(`value`: Output<Boolean>) {
        this.xForwardedForClientSrcPortEnabled = value
    }

    /**
     * @param value Whether to Enable by X-Forwarded-For Header Field Is Used to Obtain the Client IP Addresses.
     */
    @JvmName("mlepabjohpeesxjd")
    public suspend fun xForwardedForEnabled(`value`: Output<Boolean>) {
        this.xForwardedForEnabled = value
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Proto Header Field Is Used to Obtain the Server Load Balancer Instance Snooping Protocols.
     */
    @JvmName("umkuqweolwjyidul")
    public suspend fun xForwardedForProtoEnabled(`value`: Output<Boolean>) {
        this.xForwardedForProtoEnabled = value
    }

    /**
     * @param value Indicates Whether the SLB-ID Header Field Is Used to Obtain the Load Balancing Instance Id.
     */
    @JvmName("aopolixhnrlauknm")
    public suspend fun xForwardedForSlbIdEnabled(`value`: Output<Boolean>) {
        this.xForwardedForSlbIdEnabled = value
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Port Header Field Is Used to Obtain the Server Load Balancer Instance Listening Port.
     */
    @JvmName("feivkmjqawgvqrlm")
    public suspend fun xForwardedForSlbPortEnabled(`value`: Output<Boolean>) {
        this.xForwardedForSlbPortEnabled = value
    }

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_cert_client_verify_enabled` Has a Value of True, this Value Will Not Take Effect until.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("gjyvsfhskvelhlag")
    public suspend fun xForwardedForClientCertClientVerifyAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertClientVerifyAlias = mapped
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-Clientcert-clientverify` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate to Verify the Results.
     */
    @JvmName("wlytueyrxgsdwykv")
    public suspend fun xForwardedForClientCertClientVerifyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertClientVerifyEnabled = mapped
    }

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_certfingerprint_enabled`, Which Evaluates to True When the Entry into Force of.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("tdoddiusilsqrydm")
    public suspend fun xForwardedForClientCertFingerPrintAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertFingerPrintAlias = mapped
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-client_cert-fingerprint` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate Fingerprint Value.
     */
    @JvmName("ghlebndxtbcmalka")
    public suspend fun xForwardedForClientCertFingerPrintEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertFingerPrintEnabled = mapped
    }

    /**
     * @param value The Custom Header Field Names Only When `x_forwarded_for_client_cert_issuer_dn_enabled`, Which Evaluates to True When the Entry into Force of.
     */
    @JvmName("nhgsygrywkfvbwso")
    public suspend fun xForwardedForClientCertIssuerDnAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertIssuerDnAlias = mapped
    }

    /**
     * @param value Indicates Whether the `X-Forwarded-Clientcert-issuerdn` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate after the Manifests Are Signed, the Publisher Information.
     */
    @JvmName("rnvxggtiybadvriy")
    public suspend fun xForwardedForClientCertIssuerDnEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertIssuerDnEnabled = mapped
    }

    /**
     * @param value The name of the custom header. This parameter is valid only if `x_forwarded_for_client_certsubjectdn_enabled` is set to true. The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
     */
    @JvmName("wixmrmhmflafvmhh")
    public suspend fun xForwardedForClientCertSubjectDnAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertSubjectDnAlias = mapped
    }

    /**
     * @param value Specifies whether to use the `X-Forwarded-client_cert-subjectdn` header field to obtain information about the owner of the ALB client certificate. Valid values: true and false. Default value: false.
     */
    @JvmName("ankglyrmooclqxnp")
    public suspend fun xForwardedForClientCertSubjectDnEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientCertSubjectDnEnabled = mapped
    }

    /**
     * @param value Whether to use the X-Forwarded-Client-Ip header to obtain the source IP address of the server load balancer instance. Value: true, false. Note HTTP, HTTPS, and QUIC listeners support this parameter. The function corresponding to this parameter is not open by default. Please contact the account manager if you need to use it.
     */
    @JvmName("naxhjmejfeyivoru")
    public suspend fun xForwardedForClientSourceIpsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientSourceIpsEnabled = mapped
    }

    /**
     * @param value Specify the trusted proxy IP. Application-oriented load balancing ALB will traverse the X-Forwarded-For from back to front, and select the first IP that is not in the trusted IP list as the real client IP, which will be used for the source IP speed limit.
     */
    @JvmName("esckpymeifbwmcuw")
    public suspend fun xForwardedForClientSourceIpsTrusted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientSourceIpsTrusted = mapped
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Client-Port Header Field Is Used to Obtain Access to Server Load Balancer Instances to the Client, and Those of the Ports.
     */
    @JvmName("qwxaldeykuvrhbhk")
    public suspend fun xForwardedForClientSrcPortEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForClientSrcPortEnabled = mapped
    }

    /**
     * @param value Whether to Enable by X-Forwarded-For Header Field Is Used to Obtain the Client IP Addresses.
     */
    @JvmName("xyodjdhfxcsscwig")
    public suspend fun xForwardedForEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForEnabled = mapped
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Proto Header Field Is Used to Obtain the Server Load Balancer Instance Snooping Protocols.
     */
    @JvmName("fjiqfnserchfsjnc")
    public suspend fun xForwardedForProtoEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForProtoEnabled = mapped
    }

    /**
     * @param value Indicates Whether the SLB-ID Header Field Is Used to Obtain the Load Balancing Instance Id.
     */
    @JvmName("equrifpdhnkgumpr")
    public suspend fun xForwardedForSlbIdEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForSlbIdEnabled = mapped
    }

    /**
     * @param value Indicates Whether the X-Forwarded-Port Header Field Is Used to Obtain the Server Load Balancer Instance Listening Port.
     */
    @JvmName("mfcmrtbppdppeibx")
    public suspend fun xForwardedForSlbPortEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForSlbPortEnabled = mapped
    }

    internal fun build(): ListenerXForwardedForConfigArgs = ListenerXForwardedForConfigArgs(
        xForwardedForClientCertClientVerifyAlias = xForwardedForClientCertClientVerifyAlias,
        xForwardedForClientCertClientVerifyEnabled = xForwardedForClientCertClientVerifyEnabled,
        xForwardedForClientCertFingerPrintAlias = xForwardedForClientCertFingerPrintAlias,
        xForwardedForClientCertFingerPrintEnabled = xForwardedForClientCertFingerPrintEnabled,
        xForwardedForClientCertIssuerDnAlias = xForwardedForClientCertIssuerDnAlias,
        xForwardedForClientCertIssuerDnEnabled = xForwardedForClientCertIssuerDnEnabled,
        xForwardedForClientCertSubjectDnAlias = xForwardedForClientCertSubjectDnAlias,
        xForwardedForClientCertSubjectDnEnabled = xForwardedForClientCertSubjectDnEnabled,
        xForwardedForClientSourceIpsEnabled = xForwardedForClientSourceIpsEnabled,
        xForwardedForClientSourceIpsTrusted = xForwardedForClientSourceIpsTrusted,
        xForwardedForClientSrcPortEnabled = xForwardedForClientSrcPortEnabled,
        xForwardedForEnabled = xForwardedForEnabled,
        xForwardedForProtoEnabled = xForwardedForProtoEnabled,
        xForwardedForSlbIdEnabled = xForwardedForSlbIdEnabled,
        xForwardedForSlbPortEnabled = xForwardedForSlbPortEnabled,
    )
}
