@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.LoadBalancerAccessLogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logProject The project to which the access log is shipped.
 * @property logStore The Logstore to which the access log is shipped.
 */
public data class LoadBalancerAccessLogConfigArgs(
    public val logProject: Output<String>,
    public val logStore: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.LoadBalancerAccessLogConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.LoadBalancerAccessLogConfigArgs =
        com.pulumi.alicloud.alb.inputs.LoadBalancerAccessLogConfigArgs.builder()
            .logProject(logProject.applyValue({ args0 -> args0 }))
            .logStore(logStore.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerAccessLogConfigArgs].
 */
@PulumiTagMarker
public class LoadBalancerAccessLogConfigArgsBuilder internal constructor() {
    private var logProject: Output<String>? = null

    private var logStore: Output<String>? = null

    /**
     * @param value The project to which the access log is shipped.
     */
    @JvmName("fdjudlusoldmrfbq")
    public suspend fun logProject(`value`: Output<String>) {
        this.logProject = value
    }

    /**
     * @param value The Logstore to which the access log is shipped.
     */
    @JvmName("oqyhgbldmuxfxjem")
    public suspend fun logStore(`value`: Output<String>) {
        this.logStore = value
    }

    /**
     * @param value The project to which the access log is shipped.
     */
    @JvmName("iraxdrkjsntcmmfr")
    public suspend fun logProject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logProject = mapped
    }

    /**
     * @param value The Logstore to which the access log is shipped.
     */
    @JvmName("ixprgrpmjohwbtvw")
    public suspend fun logStore(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStore = mapped
    }

    internal fun build(): LoadBalancerAccessLogConfigArgs = LoadBalancerAccessLogConfigArgs(
        logProject = logProject ?: throw PulumiNullFieldException("logProject"),
        logStore = logStore ?: throw PulumiNullFieldException("logStore"),
    )
}
