@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.LoadBalancerLoadBalancerBillingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property payType The billing method of the ALB instance. Valid values: `PayAsYouGo`.
 */
public data class LoadBalancerLoadBalancerBillingConfigArgs(
    public val payType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.LoadBalancerLoadBalancerBillingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.LoadBalancerLoadBalancerBillingConfigArgs =
        com.pulumi.alicloud.alb.inputs.LoadBalancerLoadBalancerBillingConfigArgs.builder()
            .payType(payType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerLoadBalancerBillingConfigArgs].
 */
@PulumiTagMarker
public class LoadBalancerLoadBalancerBillingConfigArgsBuilder internal constructor() {
    private var payType: Output<String>? = null

    /**
     * @param value The billing method of the ALB instance. Valid values: `PayAsYouGo`.
     */
    @JvmName("hguwhgttmhediasi")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The billing method of the ALB instance. Valid values: `PayAsYouGo`.
     */
    @JvmName("piixexybdviofcra")
    public suspend fun payType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    internal fun build(): LoadBalancerLoadBalancerBillingConfigArgs =
        LoadBalancerLoadBalancerBillingConfigArgs(
            payType = payType ?: throw PulumiNullFieldException("payType"),
        )
}
