@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.LoadBalancerModificationProtectionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reason The reason for enabling the configuration read-only mode. **NOTE:** `reason` takes effect only if `status` is set to `ConsoleProtection`.
 * @property status Specifies whether to enable the configuration read-only mode. Valid values: `ConsoleProtection`, `NonProtection`.
 */
public data class LoadBalancerModificationProtectionConfigArgs(
    public val reason: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.LoadBalancerModificationProtectionConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.LoadBalancerModificationProtectionConfigArgs = com.pulumi.alicloud.alb.inputs.LoadBalancerModificationProtectionConfigArgs.builder()
        .reason(reason?.applyValue({ args0 -> args0 }))
        .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerModificationProtectionConfigArgs].
 */
@PulumiTagMarker
public class LoadBalancerModificationProtectionConfigArgsBuilder internal constructor() {
    private var reason: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The reason for enabling the configuration read-only mode. **NOTE:** `reason` takes effect only if `status` is set to `ConsoleProtection`.
     */
    @JvmName("lrlmhxsphfnvtacy")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Specifies whether to enable the configuration read-only mode. Valid values: `ConsoleProtection`, `NonProtection`.
     */
    @JvmName("vbbmsjjikiigcrla")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The reason for enabling the configuration read-only mode. **NOTE:** `reason` takes effect only if `status` is set to `ConsoleProtection`.
     */
    @JvmName("rpfggdprgtkupcwn")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value Specifies whether to enable the configuration read-only mode. Valid values: `ConsoleProtection`, `NonProtection`.
     */
    @JvmName("qfvvolyyqmeubvxg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): LoadBalancerModificationProtectionConfigArgs =
        LoadBalancerModificationProtectionConfigArgs(
            reason = reason,
            status = status,
        )
}
