@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property loadBalancerAddresses The IP address of the ALB instance.
 * @property vswitchId The ID of the VSwitch.
 * @property zoneId The zone ID of the ALB instance.
 */
public data class LoadBalancerZoneMappingArgs(
    public val loadBalancerAddresses: Output<List<LoadBalancerZoneMappingLoadBalancerAddressArgs>>? =
        null,
    public val vswitchId: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingArgs =
        com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingArgs.builder()
            .loadBalancerAddresses(
                loadBalancerAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerZoneMappingArgs].
 */
@PulumiTagMarker
public class LoadBalancerZoneMappingArgsBuilder internal constructor() {
    private var loadBalancerAddresses: Output<List<LoadBalancerZoneMappingLoadBalancerAddressArgs>>? =
        null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The IP address of the ALB instance.
     */
    @JvmName("cnennsktyqohfnia")
    public suspend fun loadBalancerAddresses(`value`: Output<List<LoadBalancerZoneMappingLoadBalancerAddressArgs>>) {
        this.loadBalancerAddresses = value
    }

    @JvmName("jlfhjdaygydcgbua")
    public suspend fun loadBalancerAddresses(vararg values: Output<LoadBalancerZoneMappingLoadBalancerAddressArgs>) {
        this.loadBalancerAddresses = Output.all(values.asList())
    }

    /**
     * @param values The IP address of the ALB instance.
     */
    @JvmName("vbbxtiqayhgpecjs")
    public suspend fun loadBalancerAddresses(values: List<Output<LoadBalancerZoneMappingLoadBalancerAddressArgs>>) {
        this.loadBalancerAddresses = Output.all(values)
    }

    /**
     * @param value The ID of the VSwitch.
     */
    @JvmName("ftgkritxdwnjhcwp")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the ALB instance.
     */
    @JvmName("cnijfgqnabqxogia")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The IP address of the ALB instance.
     */
    @JvmName("mxifkmofhpnneyxr")
    public suspend fun loadBalancerAddresses(`value`: List<LoadBalancerZoneMappingLoadBalancerAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerAddresses = mapped
    }

    /**
     * @param argument The IP address of the ALB instance.
     */
    @JvmName("armeamsajbbmxpty")
    public suspend fun loadBalancerAddresses(argument: List<suspend LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerAddresses = mapped
    }

    /**
     * @param argument The IP address of the ALB instance.
     */
    @JvmName("ikatdhrklbokkwjt")
    public suspend fun loadBalancerAddresses(vararg argument: suspend LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerAddresses = mapped
    }

    /**
     * @param argument The IP address of the ALB instance.
     */
    @JvmName("pbgnqjjnmtflacrn")
    public suspend fun loadBalancerAddresses(argument: suspend LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerAddresses = mapped
    }

    /**
     * @param values The IP address of the ALB instance.
     */
    @JvmName("maobgjncxdmgpxha")
    public suspend fun loadBalancerAddresses(vararg values: LoadBalancerZoneMappingLoadBalancerAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerAddresses = mapped
    }

    /**
     * @param value The ID of the VSwitch.
     */
    @JvmName("biihfsmtaflvqkfj")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the ALB instance.
     */
    @JvmName("viepwknxyckhcnun")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): LoadBalancerZoneMappingArgs = LoadBalancerZoneMappingArgs(
        loadBalancerAddresses = loadBalancerAddresses,
        vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
