@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingLoadBalancerAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address IP address. The Public IP Address, and Private IP Address from the Address Type.
 * @property allocationId The ID of the EIP.
 * @property eipType The type of the EIP.
 * @property ipv6Address Ipv6 address.
 */
public data class LoadBalancerZoneMappingLoadBalancerAddressArgs(
    public val address: Output<String>? = null,
    public val allocationId: Output<String>? = null,
    public val eipType: Output<String>? = null,
    public val ipv6Address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingLoadBalancerAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingLoadBalancerAddressArgs =
        com.pulumi.alicloud.alb.inputs.LoadBalancerZoneMappingLoadBalancerAddressArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .eipType(eipType?.applyValue({ args0 -> args0 }))
            .ipv6Address(ipv6Address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerZoneMappingLoadBalancerAddressArgs].
 */
@PulumiTagMarker
public class LoadBalancerZoneMappingLoadBalancerAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var allocationId: Output<String>? = null

    private var eipType: Output<String>? = null

    private var ipv6Address: Output<String>? = null

    /**
     * @param value IP address. The Public IP Address, and Private IP Address from the Address Type.
     */
    @JvmName("lanxddmhpobfikch")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The ID of the EIP.
     */
    @JvmName("ucousodydetngjce")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value The type of the EIP.
     */
    @JvmName("ufdmvqoekmkisomy")
    public suspend fun eipType(`value`: Output<String>) {
        this.eipType = value
    }

    /**
     * @param value Ipv6 address.
     */
    @JvmName("iltgduqrnjdhwbfr")
    public suspend fun ipv6Address(`value`: Output<String>) {
        this.ipv6Address = value
    }

    /**
     * @param value IP address. The Public IP Address, and Private IP Address from the Address Type.
     */
    @JvmName("otujmfktolghflfr")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The ID of the EIP.
     */
    @JvmName("pcjuddjdfnjvwpjd")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value The type of the EIP.
     */
    @JvmName("bjvpololqnyrwebv")
    public suspend fun eipType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipType = mapped
    }

    /**
     * @param value Ipv6 address.
     */
    @JvmName("wehpqoawuncowych")
    public suspend fun ipv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Address = mapped
    }

    internal fun build(): LoadBalancerZoneMappingLoadBalancerAddressArgs =
        LoadBalancerZoneMappingLoadBalancerAddressArgs(
            address = address,
            allocationId = allocationId,
            eipType = eipType,
            ipv6Address = ipv6Address,
        )
}
