@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property corsConfig Request forwarding based on CORS. See `cors_config` below.
 * @property fixedResponseConfig The configuration of the fixed response. See `fixed_response_config` below.
 * @property forwardGroupConfig The forward response action within ALB. See `forward_group_config` below.
 * @property insertHeaderConfig The configuration of the inserted header field. See `insert_header_config` below.
 * @property order The order of the forwarding rule actions. Valid values: `1` to `50000`. The actions are performed in ascending order. You cannot leave this parameter empty. Each value must be unique.
 * @property redirectConfig The configuration of the external redirect action. See `redirect_config` below.
 * @property removeHeaderConfig The configuration of the inserted header field. See `remove_header_config` below.
 * @property rewriteConfig The redirect action within ALB. See `rewrite_config` below.
 * @property trafficLimitConfig The Flow speed limit. See `traffic_limit_config` below.
 * @property trafficMirrorConfig The Traffic mirroring. See `traffic_mirror_config` below.
 * @property type The action type. Valid values: `ForwardGroup`, `Redirect`, `FixedResponse`, `Rewrite`, `InsertHeader`, `RemoveHeader`, `TrafficLimit`, `TrafficMirror` and `Cors`.
 * **Note:** The preceding actions can be classified into two types:  `FinalType`: A forwarding rule can contain only one `FinalType` action, which is executed last. This type of action can contain only one `ForwardGroup`, `Redirect` or `FixedResponse` action. `ExtType`: A forwarding rule can contain one or more `ExtType` actions, which are executed before `FinalType` actions and need to coexist with the `FinalType` actions. This type of action can contain multiple `InsertHeader` actions or one `Rewrite` action.
 * **NOTE:** The `TrafficLimit` and `TrafficMirror` option is available since 1.162.0.
 * **NOTE:** From version 1.205.0, `type` can be set to `Cors`.
 */
public data class RuleRuleActionArgs(
    public val corsConfig: Output<RuleRuleActionCorsConfigArgs>? = null,
    public val fixedResponseConfig: Output<RuleRuleActionFixedResponseConfigArgs>? = null,
    public val forwardGroupConfig: Output<RuleRuleActionForwardGroupConfigArgs>? = null,
    public val insertHeaderConfig: Output<RuleRuleActionInsertHeaderConfigArgs>? = null,
    public val order: Output<Int>,
    public val redirectConfig: Output<RuleRuleActionRedirectConfigArgs>? = null,
    public val removeHeaderConfig: Output<RuleRuleActionRemoveHeaderConfigArgs>? = null,
    public val rewriteConfig: Output<RuleRuleActionRewriteConfigArgs>? = null,
    public val trafficLimitConfig: Output<RuleRuleActionTrafficLimitConfigArgs>? = null,
    public val trafficMirrorConfig: Output<RuleRuleActionTrafficMirrorConfigArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionArgs.builder()
            .corsConfig(corsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedResponseConfig(
                fixedResponseConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .forwardGroupConfig(
                forwardGroupConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .insertHeaderConfig(
                insertHeaderConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .order(order.applyValue({ args0 -> args0 }))
            .redirectConfig(redirectConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .removeHeaderConfig(
                removeHeaderConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rewriteConfig(rewriteConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trafficLimitConfig(
                trafficLimitConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trafficMirrorConfig(
                trafficMirrorConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionArgs].
 */
@PulumiTagMarker
public class RuleRuleActionArgsBuilder internal constructor() {
    private var corsConfig: Output<RuleRuleActionCorsConfigArgs>? = null

    private var fixedResponseConfig: Output<RuleRuleActionFixedResponseConfigArgs>? = null

    private var forwardGroupConfig: Output<RuleRuleActionForwardGroupConfigArgs>? = null

    private var insertHeaderConfig: Output<RuleRuleActionInsertHeaderConfigArgs>? = null

    private var order: Output<Int>? = null

    private var redirectConfig: Output<RuleRuleActionRedirectConfigArgs>? = null

    private var removeHeaderConfig: Output<RuleRuleActionRemoveHeaderConfigArgs>? = null

    private var rewriteConfig: Output<RuleRuleActionRewriteConfigArgs>? = null

    private var trafficLimitConfig: Output<RuleRuleActionTrafficLimitConfigArgs>? = null

    private var trafficMirrorConfig: Output<RuleRuleActionTrafficMirrorConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Request forwarding based on CORS. See `cors_config` below.
     */
    @JvmName("dijnnrnawxplitct")
    public suspend fun corsConfig(`value`: Output<RuleRuleActionCorsConfigArgs>) {
        this.corsConfig = value
    }

    /**
     * @param value The configuration of the fixed response. See `fixed_response_config` below.
     */
    @JvmName("hsqsukcfwmfmmyrq")
    public suspend fun fixedResponseConfig(`value`: Output<RuleRuleActionFixedResponseConfigArgs>) {
        this.fixedResponseConfig = value
    }

    /**
     * @param value The forward response action within ALB. See `forward_group_config` below.
     */
    @JvmName("kvrykyttyejgmjlw")
    public suspend fun forwardGroupConfig(`value`: Output<RuleRuleActionForwardGroupConfigArgs>) {
        this.forwardGroupConfig = value
    }

    /**
     * @param value The configuration of the inserted header field. See `insert_header_config` below.
     */
    @JvmName("ibsashuftkuqtkto")
    public suspend fun insertHeaderConfig(`value`: Output<RuleRuleActionInsertHeaderConfigArgs>) {
        this.insertHeaderConfig = value
    }

    /**
     * @param value The order of the forwarding rule actions. Valid values: `1` to `50000`. The actions are performed in ascending order. You cannot leave this parameter empty. Each value must be unique.
     */
    @JvmName("xsgncqyoopjknrwr")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value The configuration of the external redirect action. See `redirect_config` below.
     */
    @JvmName("tjnecyjiaotpnxhb")
    public suspend fun redirectConfig(`value`: Output<RuleRuleActionRedirectConfigArgs>) {
        this.redirectConfig = value
    }

    /**
     * @param value The configuration of the inserted header field. See `remove_header_config` below.
     */
    @JvmName("gojlylllyvngijle")
    public suspend fun removeHeaderConfig(`value`: Output<RuleRuleActionRemoveHeaderConfigArgs>) {
        this.removeHeaderConfig = value
    }

    /**
     * @param value The redirect action within ALB. See `rewrite_config` below.
     */
    @JvmName("cuojpdyqfrhieuix")
    public suspend fun rewriteConfig(`value`: Output<RuleRuleActionRewriteConfigArgs>) {
        this.rewriteConfig = value
    }

    /**
     * @param value The Flow speed limit. See `traffic_limit_config` below.
     */
    @JvmName("cbygkqfabtdgfvcb")
    public suspend fun trafficLimitConfig(`value`: Output<RuleRuleActionTrafficLimitConfigArgs>) {
        this.trafficLimitConfig = value
    }

    /**
     * @param value The Traffic mirroring. See `traffic_mirror_config` below.
     */
    @JvmName("qcccbeclcakbxsjh")
    public suspend fun trafficMirrorConfig(`value`: Output<RuleRuleActionTrafficMirrorConfigArgs>) {
        this.trafficMirrorConfig = value
    }

    /**
     * @param value The action type. Valid values: `ForwardGroup`, `Redirect`, `FixedResponse`, `Rewrite`, `InsertHeader`, `RemoveHeader`, `TrafficLimit`, `TrafficMirror` and `Cors`.
     * **Note:** The preceding actions can be classified into two types:  `FinalType`: A forwarding rule can contain only one `FinalType` action, which is executed last. This type of action can contain only one `ForwardGroup`, `Redirect` or `FixedResponse` action. `ExtType`: A forwarding rule can contain one or more `ExtType` actions, which are executed before `FinalType` actions and need to coexist with the `FinalType` actions. This type of action can contain multiple `InsertHeader` actions or one `Rewrite` action.
     * **NOTE:** The `TrafficLimit` and `TrafficMirror` option is available since 1.162.0.
     * **NOTE:** From version 1.205.0, `type` can be set to `Cors`.
     */
    @JvmName("jehuunjwkajwtfku")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Request forwarding based on CORS. See `cors_config` below.
     */
    @JvmName("ajyytjwfahaxxhaq")
    public suspend fun corsConfig(`value`: RuleRuleActionCorsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfig = mapped
    }

    /**
     * @param argument Request forwarding based on CORS. See `cors_config` below.
     */
    @JvmName("phnhcnhkxpmtwafh")
    public suspend fun corsConfig(argument: suspend RuleRuleActionCorsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionCorsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfig = mapped
    }

    /**
     * @param value The configuration of the fixed response. See `fixed_response_config` below.
     */
    @JvmName("gusdajdcidrifngw")
    public suspend fun fixedResponseConfig(`value`: RuleRuleActionFixedResponseConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedResponseConfig = mapped
    }

    /**
     * @param argument The configuration of the fixed response. See `fixed_response_config` below.
     */
    @JvmName("baulekemjnpgnrbd")
    public suspend fun fixedResponseConfig(argument: suspend RuleRuleActionFixedResponseConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionFixedResponseConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fixedResponseConfig = mapped
    }

    /**
     * @param value The forward response action within ALB. See `forward_group_config` below.
     */
    @JvmName("xwbrwerjpdeylloe")
    public suspend fun forwardGroupConfig(`value`: RuleRuleActionForwardGroupConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardGroupConfig = mapped
    }

    /**
     * @param argument The forward response action within ALB. See `forward_group_config` below.
     */
    @JvmName("gdnopsysfhybwcsh")
    public suspend fun forwardGroupConfig(argument: suspend RuleRuleActionForwardGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionForwardGroupConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardGroupConfig = mapped
    }

    /**
     * @param value The configuration of the inserted header field. See `insert_header_config` below.
     */
    @JvmName("xhnyqfipagugwxwp")
    public suspend fun insertHeaderConfig(`value`: RuleRuleActionInsertHeaderConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insertHeaderConfig = mapped
    }

    /**
     * @param argument The configuration of the inserted header field. See `insert_header_config` below.
     */
    @JvmName("chwfrwsbyxeviobw")
    public suspend fun insertHeaderConfig(argument: suspend RuleRuleActionInsertHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionInsertHeaderConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.insertHeaderConfig = mapped
    }

    /**
     * @param value The order of the forwarding rule actions. Valid values: `1` to `50000`. The actions are performed in ascending order. You cannot leave this parameter empty. Each value must be unique.
     */
    @JvmName("lodmcdeatvctvgsw")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The configuration of the external redirect action. See `redirect_config` below.
     */
    @JvmName("hxbvqdcbnasmydbj")
    public suspend fun redirectConfig(`value`: RuleRuleActionRedirectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectConfig = mapped
    }

    /**
     * @param argument The configuration of the external redirect action. See `redirect_config` below.
     */
    @JvmName("gltauaatxpgfywae")
    public suspend fun redirectConfig(argument: suspend RuleRuleActionRedirectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionRedirectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirectConfig = mapped
    }

    /**
     * @param value The configuration of the inserted header field. See `remove_header_config` below.
     */
    @JvmName("mkuxsgibbgnocdyk")
    public suspend fun removeHeaderConfig(`value`: RuleRuleActionRemoveHeaderConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removeHeaderConfig = mapped
    }

    /**
     * @param argument The configuration of the inserted header field. See `remove_header_config` below.
     */
    @JvmName("yevlquxwlgohtaqj")
    public suspend fun removeHeaderConfig(argument: suspend RuleRuleActionRemoveHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionRemoveHeaderConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.removeHeaderConfig = mapped
    }

    /**
     * @param value The redirect action within ALB. See `rewrite_config` below.
     */
    @JvmName("dagbstkyiuwsypka")
    public suspend fun rewriteConfig(`value`: RuleRuleActionRewriteConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteConfig = mapped
    }

    /**
     * @param argument The redirect action within ALB. See `rewrite_config` below.
     */
    @JvmName("xnflnvfkrtkhxqry")
    public suspend fun rewriteConfig(argument: suspend RuleRuleActionRewriteConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionRewriteConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rewriteConfig = mapped
    }

    /**
     * @param value The Flow speed limit. See `traffic_limit_config` below.
     */
    @JvmName("rkmsslrfabgdfmjq")
    public suspend fun trafficLimitConfig(`value`: RuleRuleActionTrafficLimitConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficLimitConfig = mapped
    }

    /**
     * @param argument The Flow speed limit. See `traffic_limit_config` below.
     */
    @JvmName("qopaqkxvkkuhbsvg")
    public suspend fun trafficLimitConfig(argument: suspend RuleRuleActionTrafficLimitConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionTrafficLimitConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trafficLimitConfig = mapped
    }

    /**
     * @param value The Traffic mirroring. See `traffic_mirror_config` below.
     */
    @JvmName("pixeixnfuothxhol")
    public suspend fun trafficMirrorConfig(`value`: RuleRuleActionTrafficMirrorConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorConfig = mapped
    }

    /**
     * @param argument The Traffic mirroring. See `traffic_mirror_config` below.
     */
    @JvmName("jfrsgarfobhgfhkf")
    public suspend fun trafficMirrorConfig(argument: suspend RuleRuleActionTrafficMirrorConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionTrafficMirrorConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trafficMirrorConfig = mapped
    }

    /**
     * @param value The action type. Valid values: `ForwardGroup`, `Redirect`, `FixedResponse`, `Rewrite`, `InsertHeader`, `RemoveHeader`, `TrafficLimit`, `TrafficMirror` and `Cors`.
     * **Note:** The preceding actions can be classified into two types:  `FinalType`: A forwarding rule can contain only one `FinalType` action, which is executed last. This type of action can contain only one `ForwardGroup`, `Redirect` or `FixedResponse` action. `ExtType`: A forwarding rule can contain one or more `ExtType` actions, which are executed before `FinalType` actions and need to coexist with the `FinalType` actions. This type of action can contain multiple `InsertHeader` actions or one `Rewrite` action.
     * **NOTE:** The `TrafficLimit` and `TrafficMirror` option is available since 1.162.0.
     * **NOTE:** From version 1.205.0, `type` can be set to `Cors`.
     */
    @JvmName("awbhfbmacilflksa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleRuleActionArgs = RuleRuleActionArgs(
        corsConfig = corsConfig,
        fixedResponseConfig = fixedResponseConfig,
        forwardGroupConfig = forwardGroupConfig,
        insertHeaderConfig = insertHeaderConfig,
        order = order ?: throw PulumiNullFieldException("order"),
        redirectConfig = redirectConfig,
        removeHeaderConfig = removeHeaderConfig,
        rewriteConfig = rewriteConfig,
        trafficLimitConfig = trafficLimitConfig,
        trafficMirrorConfig = trafficMirrorConfig,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
