@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionCorsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowCredentials Specifies whether credentials can be passed during CORS operations. Valid values: `on`, `off`.
 * @property allowHeaders The allowed headers for CORS requests.
 * @property allowMethods The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
 * @property allowOrigins The allowed origins of CORS requests.
 * @property exposeHeaders The headers that can be exposed.
 * @property maxAge The maximum cache time of preflight requests in the browser. Unit: seconds. Valid values: `-1` to `172800`.
 */
public data class RuleRuleActionCorsConfigArgs(
    public val allowCredentials: Output<String>? = null,
    public val allowHeaders: Output<List<String>>? = null,
    public val allowMethods: Output<List<String>>? = null,
    public val allowOrigins: Output<List<String>>? = null,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionCorsConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionCorsConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionCorsConfigArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowHeaders(allowHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowMethods(allowMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowOrigins(allowOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionCorsConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionCorsConfigArgsBuilder internal constructor() {
    private var allowCredentials: Output<String>? = null

    private var allowHeaders: Output<List<String>>? = null

    private var allowMethods: Output<List<String>>? = null

    private var allowOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value Specifies whether credentials can be passed during CORS operations. Valid values: `on`, `off`.
     */
    @JvmName("wbetsnykptrbeqbm")
    public suspend fun allowCredentials(`value`: Output<String>) {
        this.allowCredentials = value
    }

    /**
     * @param value The allowed headers for CORS requests.
     */
    @JvmName("qhgsmyecdspwqgib")
    public suspend fun allowHeaders(`value`: Output<List<String>>) {
        this.allowHeaders = value
    }

    @JvmName("sboclxiietvwgtcl")
    public suspend fun allowHeaders(vararg values: Output<String>) {
        this.allowHeaders = Output.all(values.asList())
    }

    /**
     * @param values The allowed headers for CORS requests.
     */
    @JvmName("sqhrmlcathbolawi")
    public suspend fun allowHeaders(values: List<Output<String>>) {
        this.allowHeaders = Output.all(values)
    }

    /**
     * @param value The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
     */
    @JvmName("srykivfddyiixvdc")
    public suspend fun allowMethods(`value`: Output<List<String>>) {
        this.allowMethods = value
    }

    @JvmName("ptbexgtcqympvaqv")
    public suspend fun allowMethods(vararg values: Output<String>) {
        this.allowMethods = Output.all(values.asList())
    }

    /**
     * @param values The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
     */
    @JvmName("iulltvjoqusnpski")
    public suspend fun allowMethods(values: List<Output<String>>) {
        this.allowMethods = Output.all(values)
    }

    /**
     * @param value The allowed origins of CORS requests.
     */
    @JvmName("flrfdxpwnwjcmltk")
    public suspend fun allowOrigins(`value`: Output<List<String>>) {
        this.allowOrigins = value
    }

    @JvmName("nkrlnarysclyencg")
    public suspend fun allowOrigins(vararg values: Output<String>) {
        this.allowOrigins = Output.all(values.asList())
    }

    /**
     * @param values The allowed origins of CORS requests.
     */
    @JvmName("tkeknbbrghgsaxbk")
    public suspend fun allowOrigins(values: List<Output<String>>) {
        this.allowOrigins = Output.all(values)
    }

    /**
     * @param value The headers that can be exposed.
     */
    @JvmName("cdnnvbfnekynxgqp")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("parxsmanxwpxftsb")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values The headers that can be exposed.
     */
    @JvmName("juncvjwrolapupfy")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value The maximum cache time of preflight requests in the browser. Unit: seconds. Valid values: `-1` to `172800`.
     */
    @JvmName("necojhhgeemcpenm")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value Specifies whether credentials can be passed during CORS operations. Valid values: `on`, `off`.
     */
    @JvmName("mjuxuhfxllxfqins")
    public suspend fun allowCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value The allowed headers for CORS requests.
     */
    @JvmName("xwdkbusawxxfivar")
    public suspend fun allowHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param values The allowed headers for CORS requests.
     */
    @JvmName("askmxdjdaglsrhwg")
    public suspend fun allowHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param value The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
     */
    @JvmName("okeiybjrjptugovd")
    public suspend fun allowMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param values The allowed HTTP methods for CORS requests. Valid values: `GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `PATCH`.
     */
    @JvmName("ajdiarqutcbohqkw")
    public suspend fun allowMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param value The allowed origins of CORS requests.
     */
    @JvmName("nuommlwjaghpillc")
    public suspend fun allowOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param values The allowed origins of CORS requests.
     */
    @JvmName("udvnhmappjueavon")
    public suspend fun allowOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param value The headers that can be exposed.
     */
    @JvmName("nbhuefbdbheqtugb")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values The headers that can be exposed.
     */
    @JvmName("uvjqekjncfxmyhab")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value The maximum cache time of preflight requests in the browser. Unit: seconds. Valid values: `-1` to `172800`.
     */
    @JvmName("isiaentmtiyeawbc")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): RuleRuleActionCorsConfigArgs = RuleRuleActionCorsConfigArgs(
        allowCredentials = allowCredentials,
        allowHeaders = allowHeaders,
        allowMethods = allowMethods,
        allowOrigins = allowOrigins,
        exposeHeaders = exposeHeaders,
        maxAge = maxAge,
    )
}
