@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionFixedResponseConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The fixed response. The response cannot exceed 1 KB in size and can contain only ASCII characters.
 * @property contentType The format of the fixed response. Valid values: `text/plain`, `text/css`, `text/html`, `application/javascript`, and `application/json`.
 * @property httpCode The redirect method. Valid values: `301`, `302`, `303`, `307`, and `308`.
 */
public data class RuleRuleActionFixedResponseConfigArgs(
    public val content: Output<String>,
    public val contentType: Output<String>? = null,
    public val httpCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionFixedResponseConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionFixedResponseConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionFixedResponseConfigArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .httpCode(httpCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionFixedResponseConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionFixedResponseConfigArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var httpCode: Output<String>? = null

    /**
     * @param value The fixed response. The response cannot exceed 1 KB in size and can contain only ASCII characters.
     */
    @JvmName("rjuuqlgcitnhwtnm")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The format of the fixed response. Valid values: `text/plain`, `text/css`, `text/html`, `application/javascript`, and `application/json`.
     */
    @JvmName("svbeoyvdvnvnwjme")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The redirect method. Valid values: `301`, `302`, `303`, `307`, and `308`.
     */
    @JvmName("jvebuskplgbwwppt")
    public suspend fun httpCode(`value`: Output<String>) {
        this.httpCode = value
    }

    /**
     * @param value The fixed response. The response cannot exceed 1 KB in size and can contain only ASCII characters.
     */
    @JvmName("mhfohieejdeaolqp")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The format of the fixed response. Valid values: `text/plain`, `text/css`, `text/html`, `application/javascript`, and `application/json`.
     */
    @JvmName("lfgshraxbmrlmieu")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The redirect method. Valid values: `301`, `302`, `303`, `307`, and `308`.
     */
    @JvmName("ukexfmymcrpitgew")
    public suspend fun httpCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpCode = mapped
    }

    internal fun build(): RuleRuleActionFixedResponseConfigArgs =
        RuleRuleActionFixedResponseConfigArgs(
            content = content ?: throw PulumiNullFieldException("content"),
            contentType = contentType,
            httpCode = httpCode,
        )
}
