@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupStickySession The configuration of session persistence for server groups. See `server_group_sticky_session` below.
 * @property serverGroupTuples The destination server group to which requests are forwarded. See `server_group_tuples` below.
 */
public data class RuleRuleActionForwardGroupConfigArgs(
    public val serverGroupStickySession: Output<RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs>? = null,
    public val serverGroupTuples: Output<List<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigArgs.builder()
            .serverGroupStickySession(
                serverGroupStickySession?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serverGroupTuples(
                serverGroupTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleRuleActionForwardGroupConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionForwardGroupConfigArgsBuilder internal constructor() {
    private var serverGroupStickySession:
        Output<RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs>? = null

    private var serverGroupTuples: Output<List<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>>? =
        null

    /**
     * @param value The configuration of session persistence for server groups. See `server_group_sticky_session` below.
     */
    @JvmName("ginabylnmqjssest")
    public suspend fun serverGroupStickySession(`value`: Output<RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs>) {
        this.serverGroupStickySession = value
    }

    /**
     * @param value The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("pppuevepsrmukjuo")
    public suspend fun serverGroupTuples(`value`: Output<List<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = value
    }

    @JvmName("kiljrplfhqlenixl")
    public suspend fun serverGroupTuples(vararg values: Output<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>) {
        this.serverGroupTuples = Output.all(values.asList())
    }

    /**
     * @param values The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("xjterevpvonvsfdc")
    public suspend fun serverGroupTuples(values: List<Output<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>>) {
        this.serverGroupTuples = Output.all(values)
    }

    /**
     * @param value The configuration of session persistence for server groups. See `server_group_sticky_session` below.
     */
    @JvmName("rqrsguoeofjicmpf")
    public suspend fun serverGroupStickySession(`value`: RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupStickySession = mapped
    }

    /**
     * @param argument The configuration of session persistence for server groups. See `server_group_sticky_session` below.
     */
    @JvmName("ectvjhjwxwhywbph")
    public suspend fun serverGroupStickySession(argument: suspend RuleRuleActionForwardGroupConfigServerGroupStickySessionArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleRuleActionForwardGroupConfigServerGroupStickySessionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serverGroupStickySession = mapped
    }

    /**
     * @param value The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("eesatpwkbujyawuj")
    public suspend fun serverGroupTuples(`value`: List<RuleRuleActionForwardGroupConfigServerGroupTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("ivgcctqfrfbwircw")
    public suspend fun serverGroupTuples(argument: List<suspend RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("kxnfcsqrvtofcfwq")
    public suspend fun serverGroupTuples(vararg argument: suspend RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param argument The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("yofabfojtolvmqwb")
    public suspend fun serverGroupTuples(argument: suspend RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.serverGroupTuples = mapped
    }

    /**
     * @param values The destination server group to which requests are forwarded. See `server_group_tuples` below.
     */
    @JvmName("snqsmfhvrambqktd")
    public suspend fun serverGroupTuples(vararg values: RuleRuleActionForwardGroupConfigServerGroupTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverGroupTuples = mapped
    }

    internal fun build(): RuleRuleActionForwardGroupConfigArgs = RuleRuleActionForwardGroupConfigArgs(
        serverGroupStickySession = serverGroupStickySession,
        serverGroupTuples = serverGroupTuples,
    )
}
