@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether to enable session persistence.
 * @property timeout The timeout period. Unit: seconds. Valid values: `1` to `86400`. Default value: `1000`.
 */
public data class RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs(
    public val enabled: Output<Boolean>? = null,
    public val timeout: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs].
 */
@PulumiTagMarker
public class RuleRuleActionForwardGroupConfigServerGroupStickySessionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value Whether to enable session persistence.
     */
    @JvmName("bqlcsiwjkdyenhnt")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The timeout period. Unit: seconds. Valid values: `1` to `86400`. Default value: `1000`.
     */
    @JvmName("xbhqualitcdymyqx")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Whether to enable session persistence.
     */
    @JvmName("hpuvhsfsrwdjbexv")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The timeout period. Unit: seconds. Valid values: `1` to `86400`. Default value: `1000`.
     */
    @JvmName("ddkdfwfsauqutkgu")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs =
        RuleRuleActionForwardGroupConfigServerGroupStickySessionArgs(
            enabled = enabled,
            timeout = timeout,
        )
}
