@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupId The ID of the destination server group to which requests are forwarded.
 * @property weight The Weight of server group. Default value: `100`. **NOTE:** This attribute is required when the number of `server_group_tuples` is greater than 2.
 */
public data class RuleRuleActionForwardGroupConfigServerGroupTupleArgs(
    public val serverGroupId: Output<String>? = null,
    public val weight: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupTupleArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupTupleArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionForwardGroupConfigServerGroupTupleArgs.builder()
            .serverGroupId(serverGroupId?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionForwardGroupConfigServerGroupTupleArgs].
 */
@PulumiTagMarker
public class RuleRuleActionForwardGroupConfigServerGroupTupleArgsBuilder internal constructor() {
    private var serverGroupId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("suxxtiqvornmwrdn")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value The Weight of server group. Default value: `100`. **NOTE:** This attribute is required when the number of `server_group_tuples` is greater than 2.
     */
    @JvmName("rhyfkjaquqijjkvd")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("ioecocgljbmyxesw")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    /**
     * @param value The Weight of server group. Default value: `100`. **NOTE:** This attribute is required when the number of `server_group_tuples` is greater than 2.
     */
    @JvmName("dhsntguscbkysyni")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): RuleRuleActionForwardGroupConfigServerGroupTupleArgs =
        RuleRuleActionForwardGroupConfigServerGroupTupleArgs(
            serverGroupId = serverGroupId,
            weight = weight,
        )
}
