@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionInsertHeaderConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property value
 * @property valueType The value type of the inserted header field. Valid values:
 * - `UserDefined`: a custom value
 * - `ReferenceHeader`: uses a field of the user request header.
 * - `SystemDefined`: a system value.
 */
public data class RuleRuleActionInsertHeaderConfigArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val valueType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionInsertHeaderConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionInsertHeaderConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionInsertHeaderConfigArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueType(valueType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionInsertHeaderConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionInsertHeaderConfigArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    private var valueType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("htcslgnuarcbhewg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("xvcbiokcoxosrcok")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The value type of the inserted header field. Valid values:
     * - `UserDefined`: a custom value
     * - `ReferenceHeader`: uses a field of the user request header.
     * - `SystemDefined`: a system value.
     */
    @JvmName("iorldilqxuvhcxuh")
    public suspend fun valueType(`value`: Output<String>) {
        this.valueType = value
    }

    /**
     * @param value
     */
    @JvmName("pwnusclfwospivqf")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("qnmmicpreyiijtsa")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The value type of the inserted header field. Valid values:
     * - `UserDefined`: a custom value
     * - `ReferenceHeader`: uses a field of the user request header.
     * - `SystemDefined`: a system value.
     */
    @JvmName("njlvknmowddinbbt")
    public suspend fun valueType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    internal fun build(): RuleRuleActionInsertHeaderConfigArgs = RuleRuleActionInsertHeaderConfigArgs(
        key = key,
        `value` = `value`,
        valueType = valueType,
    )
}
