@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficLimitConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property perIpQps The number of requests per second for a single IP address. Value range: 1~1000000. Note: If the QPS parameter is also configured, the value of the PerIpQps parameter must be smaller than the value of the QPS parameter.
 * @property qps The Number of requests per second. Valid values: `1` to `100000`.
 */
public data class RuleRuleActionTrafficLimitConfigArgs(
    public val perIpQps: Output<Int>? = null,
    public val qps: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficLimitConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficLimitConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficLimitConfigArgs.builder()
            .perIpQps(perIpQps?.applyValue({ args0 -> args0 }))
            .qps(qps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionTrafficLimitConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionTrafficLimitConfigArgsBuilder internal constructor() {
    private var perIpQps: Output<Int>? = null

    private var qps: Output<Int>? = null

    /**
     * @param value The number of requests per second for a single IP address. Value range: 1~1000000. Note: If the QPS parameter is also configured, the value of the PerIpQps parameter must be smaller than the value of the QPS parameter.
     */
    @JvmName("ankootrghmeweohi")
    public suspend fun perIpQps(`value`: Output<Int>) {
        this.perIpQps = value
    }

    /**
     * @param value The Number of requests per second. Valid values: `1` to `100000`.
     */
    @JvmName("ncbsxpbhivelmple")
    public suspend fun qps(`value`: Output<Int>) {
        this.qps = value
    }

    /**
     * @param value The number of requests per second for a single IP address. Value range: 1~1000000. Note: If the QPS parameter is also configured, the value of the PerIpQps parameter must be smaller than the value of the QPS parameter.
     */
    @JvmName("xilyfkyjswtffpqi")
    public suspend fun perIpQps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perIpQps = mapped
    }

    /**
     * @param value The Number of requests per second. Valid values: `1` to `100000`.
     */
    @JvmName("ddgicynffbjnrnbe")
    public suspend fun qps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qps = mapped
    }

    internal fun build(): RuleRuleActionTrafficLimitConfigArgs = RuleRuleActionTrafficLimitConfigArgs(
        perIpQps = perIpQps,
        qps = qps,
    )
}
