@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mirrorGroupConfig The Traffic is mirrored to the server group. See `mirror_group_config` below.
 * @property targetType The Mirror target type.
 */
public data class RuleRuleActionTrafficMirrorConfigArgs(
    public val mirrorGroupConfig: Output<RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgs>? =
        null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigArgs.builder()
            .mirrorGroupConfig(mirrorGroupConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionTrafficMirrorConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleActionTrafficMirrorConfigArgsBuilder internal constructor() {
    private var mirrorGroupConfig: Output<RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgs>? =
        null

    private var targetType: Output<String>? = null

    /**
     * @param value The Traffic is mirrored to the server group. See `mirror_group_config` below.
     */
    @JvmName("esvvmsmeuedfavjt")
    public suspend fun mirrorGroupConfig(`value`: Output<RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgs>) {
        this.mirrorGroupConfig = value
    }

    /**
     * @param value The Mirror target type.
     */
    @JvmName("gxcmgovcuecixgft")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value The Traffic is mirrored to the server group. See `mirror_group_config` below.
     */
    @JvmName("soltfpqdmcpfccqj")
    public suspend fun mirrorGroupConfig(`value`: RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorGroupConfig = mapped
    }

    /**
     * @param argument The Traffic is mirrored to the server group. See `mirror_group_config` below.
     */
    @JvmName("eygtagyjhrvvhsww")
    public suspend fun mirrorGroupConfig(argument: suspend RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleActionTrafficMirrorConfigMirrorGroupConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mirrorGroupConfig = mapped
    }

    /**
     * @param value The Mirror target type.
     */
    @JvmName("vepbxicwddcilcuj")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): RuleRuleActionTrafficMirrorConfigArgs =
        RuleRuleActionTrafficMirrorConfigArgs(
            mirrorGroupConfig = mirrorGroupConfig,
            targetType = targetType,
        )
}
