@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverGroupId The ID of the destination server group to which requests are forwarded.
 */
public data class RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs(
    public val serverGroupId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs.builder()
            .serverGroupId(serverGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs].
 */
@PulumiTagMarker
public class RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgsBuilder internal constructor() {
    private var serverGroupId: Output<String>? = null

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("humhwbenfrapdrdg")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value The ID of the destination server group to which requests are forwarded.
     */
    @JvmName("acioxclcktsjcnle")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    internal fun build(): RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs =
        RuleRuleActionTrafficMirrorConfigMirrorGroupConfigServerGroupTupleArgs(
            serverGroupId = serverGroupId,
        )
}
