@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookieConfig The configuration of the cookie. See See `cookie_config` below.
 * @property headerConfig The configuration of the header field. See `header_config` below.
 * @property hostConfig The configuration of the host field. See `host_config` below.
 * @property methodConfig The configuration of the request method. See `method_config` below.
 * @property pathConfig The configuration of the path for the request to be forwarded. See `path_config` below.
 * @property queryStringConfig The configuration of the query string. See `query_string_config` below.
 * @property responseHeaderConfig The configuration of the header field. See `response_header_config` below.
 * @property responseStatusCodeConfig The configuration of the header field. See `response_status_code_config` below.
 * @property sourceIpConfig The Based on source IP traffic matching. Required and valid when Type is SourceIP. See `source_ip_config` below.
 * @property type The type of the forwarding rule. Valid values:
 * - `Host`: Requests are forwarded based on hosts.
 * - `Path`: Requests are forwarded based on the path.
 * - `Header`: Requests are forwarded based on the HTTP header field.
 * - `QueryString`: Requests are forwarded based on the query string.
 * - `Method`: Request are forwarded based on the request method.
 * - `Cookie`: Requests are forwarded based on the cookie.
 * - `SourceIp`: Requests are forwarded based on the source ip. **NOTE:** The `SourceIp` option is available since 1.162.0.
 * - `ResponseHeader`: Response header. **NOTE:** The `SourceIp` option is available since 1.213.1.
 * - `ResponseStatusCode`: Response status code. **NOTE:** The `SourceIp` option is available since 1.213.1.
 */
public data class RuleRuleConditionArgs(
    public val cookieConfig: Output<RuleRuleConditionCookieConfigArgs>? = null,
    public val headerConfig: Output<RuleRuleConditionHeaderConfigArgs>? = null,
    public val hostConfig: Output<RuleRuleConditionHostConfigArgs>? = null,
    public val methodConfig: Output<RuleRuleConditionMethodConfigArgs>? = null,
    public val pathConfig: Output<RuleRuleConditionPathConfigArgs>? = null,
    public val queryStringConfig: Output<RuleRuleConditionQueryStringConfigArgs>? = null,
    public val responseHeaderConfig: Output<RuleRuleConditionResponseHeaderConfigArgs>? = null,
    public val responseStatusCodeConfig: Output<RuleRuleConditionResponseStatusCodeConfigArgs>? =
        null,
    public val sourceIpConfig: Output<RuleRuleConditionSourceIpConfigArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionArgs.builder()
            .cookieConfig(cookieConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerConfig(headerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostConfig(hostConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .methodConfig(methodConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pathConfig(pathConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryStringConfig(queryStringConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .responseHeaderConfig(
                responseHeaderConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .responseStatusCodeConfig(
                responseStatusCodeConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceIpConfig(sourceIpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleRuleConditionArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionArgsBuilder internal constructor() {
    private var cookieConfig: Output<RuleRuleConditionCookieConfigArgs>? = null

    private var headerConfig: Output<RuleRuleConditionHeaderConfigArgs>? = null

    private var hostConfig: Output<RuleRuleConditionHostConfigArgs>? = null

    private var methodConfig: Output<RuleRuleConditionMethodConfigArgs>? = null

    private var pathConfig: Output<RuleRuleConditionPathConfigArgs>? = null

    private var queryStringConfig: Output<RuleRuleConditionQueryStringConfigArgs>? = null

    private var responseHeaderConfig: Output<RuleRuleConditionResponseHeaderConfigArgs>? = null

    private var responseStatusCodeConfig: Output<RuleRuleConditionResponseStatusCodeConfigArgs>? =
        null

    private var sourceIpConfig: Output<RuleRuleConditionSourceIpConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The configuration of the cookie. See See `cookie_config` below.
     */
    @JvmName("vbiplmhuspuukhwo")
    public suspend fun cookieConfig(`value`: Output<RuleRuleConditionCookieConfigArgs>) {
        this.cookieConfig = value
    }

    /**
     * @param value The configuration of the header field. See `header_config` below.
     */
    @JvmName("skbfupomeywjqkpv")
    public suspend fun headerConfig(`value`: Output<RuleRuleConditionHeaderConfigArgs>) {
        this.headerConfig = value
    }

    /**
     * @param value The configuration of the host field. See `host_config` below.
     */
    @JvmName("khanvqrfsurdwugb")
    public suspend fun hostConfig(`value`: Output<RuleRuleConditionHostConfigArgs>) {
        this.hostConfig = value
    }

    /**
     * @param value The configuration of the request method. See `method_config` below.
     */
    @JvmName("akatyafulrurakhb")
    public suspend fun methodConfig(`value`: Output<RuleRuleConditionMethodConfigArgs>) {
        this.methodConfig = value
    }

    /**
     * @param value The configuration of the path for the request to be forwarded. See `path_config` below.
     */
    @JvmName("patowqajjirbvrno")
    public suspend fun pathConfig(`value`: Output<RuleRuleConditionPathConfigArgs>) {
        this.pathConfig = value
    }

    /**
     * @param value The configuration of the query string. See `query_string_config` below.
     */
    @JvmName("cvxkahuvcvvraurb")
    public suspend fun queryStringConfig(`value`: Output<RuleRuleConditionQueryStringConfigArgs>) {
        this.queryStringConfig = value
    }

    /**
     * @param value The configuration of the header field. See `response_header_config` below.
     */
    @JvmName("wthxgqechtkuotqv")
    public suspend fun responseHeaderConfig(`value`: Output<RuleRuleConditionResponseHeaderConfigArgs>) {
        this.responseHeaderConfig = value
    }

    /**
     * @param value The configuration of the header field. See `response_status_code_config` below.
     */
    @JvmName("pbttfausrigqdbcn")
    public suspend fun responseStatusCodeConfig(`value`: Output<RuleRuleConditionResponseStatusCodeConfigArgs>) {
        this.responseStatusCodeConfig = value
    }

    /**
     * @param value The Based on source IP traffic matching. Required and valid when Type is SourceIP. See `source_ip_config` below.
     */
    @JvmName("twrextkudgwioinv")
    public suspend fun sourceIpConfig(`value`: Output<RuleRuleConditionSourceIpConfigArgs>) {
        this.sourceIpConfig = value
    }

    /**
     * @param value The type of the forwarding rule. Valid values:
     * - `Host`: Requests are forwarded based on hosts.
     * - `Path`: Requests are forwarded based on the path.
     * - `Header`: Requests are forwarded based on the HTTP header field.
     * - `QueryString`: Requests are forwarded based on the query string.
     * - `Method`: Request are forwarded based on the request method.
     * - `Cookie`: Requests are forwarded based on the cookie.
     * - `SourceIp`: Requests are forwarded based on the source ip. **NOTE:** The `SourceIp` option is available since 1.162.0.
     * - `ResponseHeader`: Response header. **NOTE:** The `SourceIp` option is available since 1.213.1.
     * - `ResponseStatusCode`: Response status code. **NOTE:** The `SourceIp` option is available since 1.213.1.
     */
    @JvmName("mvyqlaeqmulqaojw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The configuration of the cookie. See See `cookie_config` below.
     */
    @JvmName("njqtdeaerediqcrc")
    public suspend fun cookieConfig(`value`: RuleRuleConditionCookieConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieConfig = mapped
    }

    /**
     * @param argument The configuration of the cookie. See See `cookie_config` below.
     */
    @JvmName("juvkympxffwgkhof")
    public suspend fun cookieConfig(argument: suspend RuleRuleConditionCookieConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionCookieConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cookieConfig = mapped
    }

    /**
     * @param value The configuration of the header field. See `header_config` below.
     */
    @JvmName("yeycemejngodwmlw")
    public suspend fun headerConfig(`value`: RuleRuleConditionHeaderConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerConfig = mapped
    }

    /**
     * @param argument The configuration of the header field. See `header_config` below.
     */
    @JvmName("xlyjeodmbdjronbv")
    public suspend fun headerConfig(argument: suspend RuleRuleConditionHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionHeaderConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.headerConfig = mapped
    }

    /**
     * @param value The configuration of the host field. See `host_config` below.
     */
    @JvmName("vgyrwbnhhnfqwpls")
    public suspend fun hostConfig(`value`: RuleRuleConditionHostConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostConfig = mapped
    }

    /**
     * @param argument The configuration of the host field. See `host_config` below.
     */
    @JvmName("ekkphppswplweolv")
    public suspend fun hostConfig(argument: suspend RuleRuleConditionHostConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionHostConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostConfig = mapped
    }

    /**
     * @param value The configuration of the request method. See `method_config` below.
     */
    @JvmName("ogljoffmbtbrpbvr")
    public suspend fun methodConfig(`value`: RuleRuleConditionMethodConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methodConfig = mapped
    }

    /**
     * @param argument The configuration of the request method. See `method_config` below.
     */
    @JvmName("mptekqfxykoorldd")
    public suspend fun methodConfig(argument: suspend RuleRuleConditionMethodConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionMethodConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.methodConfig = mapped
    }

    /**
     * @param value The configuration of the path for the request to be forwarded. See `path_config` below.
     */
    @JvmName("oiykknbcsccykfov")
    public suspend fun pathConfig(`value`: RuleRuleConditionPathConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathConfig = mapped
    }

    /**
     * @param argument The configuration of the path for the request to be forwarded. See `path_config` below.
     */
    @JvmName("cgjamqpdwhebjgse")
    public suspend fun pathConfig(argument: suspend RuleRuleConditionPathConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionPathConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pathConfig = mapped
    }

    /**
     * @param value The configuration of the query string. See `query_string_config` below.
     */
    @JvmName("dfnudyatgslpmxuv")
    public suspend fun queryStringConfig(`value`: RuleRuleConditionQueryStringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringConfig = mapped
    }

    /**
     * @param argument The configuration of the query string. See `query_string_config` below.
     */
    @JvmName("nybbmvbmrxikvtwi")
    public suspend fun queryStringConfig(argument: suspend RuleRuleConditionQueryStringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionQueryStringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryStringConfig = mapped
    }

    /**
     * @param value The configuration of the header field. See `response_header_config` below.
     */
    @JvmName("kwehlolmpbgypjwm")
    public suspend fun responseHeaderConfig(`value`: RuleRuleConditionResponseHeaderConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaderConfig = mapped
    }

    /**
     * @param argument The configuration of the header field. See `response_header_config` below.
     */
    @JvmName("tvcpwqsmxriaqqix")
    public suspend fun responseHeaderConfig(argument: suspend RuleRuleConditionResponseHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionResponseHeaderConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.responseHeaderConfig = mapped
    }

    /**
     * @param value The configuration of the header field. See `response_status_code_config` below.
     */
    @JvmName("ijnthgthjnpttbjt")
    public suspend fun responseStatusCodeConfig(`value`: RuleRuleConditionResponseStatusCodeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseStatusCodeConfig = mapped
    }

    /**
     * @param argument The configuration of the header field. See `response_status_code_config` below.
     */
    @JvmName("qvcivjiduaprmeax")
    public suspend fun responseStatusCodeConfig(argument: suspend RuleRuleConditionResponseStatusCodeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionResponseStatusCodeConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.responseStatusCodeConfig = mapped
    }

    /**
     * @param value The Based on source IP traffic matching. Required and valid when Type is SourceIP. See `source_ip_config` below.
     */
    @JvmName("lkiotmoedxopaehk")
    public suspend fun sourceIpConfig(`value`: RuleRuleConditionSourceIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpConfig = mapped
    }

    /**
     * @param argument The Based on source IP traffic matching. Required and valid when Type is SourceIP. See `source_ip_config` below.
     */
    @JvmName("tmttvhqaddxtgimp")
    public suspend fun sourceIpConfig(argument: suspend RuleRuleConditionSourceIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleRuleConditionSourceIpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceIpConfig = mapped
    }

    /**
     * @param value The type of the forwarding rule. Valid values:
     * - `Host`: Requests are forwarded based on hosts.
     * - `Path`: Requests are forwarded based on the path.
     * - `Header`: Requests are forwarded based on the HTTP header field.
     * - `QueryString`: Requests are forwarded based on the query string.
     * - `Method`: Request are forwarded based on the request method.
     * - `Cookie`: Requests are forwarded based on the cookie.
     * - `SourceIp`: Requests are forwarded based on the source ip. **NOTE:** The `SourceIp` option is available since 1.162.0.
     * - `ResponseHeader`: Response header. **NOTE:** The `SourceIp` option is available since 1.213.1.
     * - `ResponseStatusCode`: Response status code. **NOTE:** The `SourceIp` option is available since 1.213.1.
     */
    @JvmName("pkfrfypihbftwcso")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleRuleConditionArgs = RuleRuleConditionArgs(
        cookieConfig = cookieConfig,
        headerConfig = headerConfig,
        hostConfig = hostConfig,
        methodConfig = methodConfig,
        pathConfig = pathConfig,
        queryStringConfig = queryStringConfig,
        responseHeaderConfig = responseHeaderConfig,
        responseStatusCodeConfig = responseStatusCodeConfig,
        sourceIpConfig = sourceIpConfig,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
