@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionCookieConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
 */
public data class RuleRuleConditionCookieConfigArgs(
    public val values: Output<List<RuleRuleConditionCookieConfigValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionCookieConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionCookieConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionCookieConfigArgs.builder()
            .values(
                values?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleRuleConditionCookieConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionCookieConfigArgsBuilder internal constructor() {
    private var values: Output<List<RuleRuleConditionCookieConfigValueArgs>>? = null

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ihkhqqkjnekmijeq")
    public suspend fun values(`value`: Output<List<RuleRuleConditionCookieConfigValueArgs>>) {
        this.values = value
    }

    @JvmName("pdeoapoaovowlmxn")
    public suspend fun values(vararg values: Output<RuleRuleConditionCookieConfigValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("dpqqiowrvdbtcfji")
    public suspend fun values(values: List<Output<RuleRuleConditionCookieConfigValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ymsuhcdqrmjnhkkn")
    public suspend fun values(`value`: List<RuleRuleConditionCookieConfigValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("uvyhbdtbuwvlopce")
    public suspend fun values(argument: List<suspend RuleRuleConditionCookieConfigValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionCookieConfigValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("unoqfhltamvmysid")
    public suspend fun values(vararg argument: suspend RuleRuleConditionCookieConfigValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionCookieConfigValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("nxdnatargbxolkqr")
    public suspend fun values(argument: suspend RuleRuleConditionCookieConfigValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleRuleConditionCookieConfigValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ogksirnxvrcfwxsm")
    public suspend fun values(vararg values: RuleRuleConditionCookieConfigValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): RuleRuleConditionCookieConfigArgs = RuleRuleConditionCookieConfigArgs(
        values = values,
    )
}
