@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionHeaderConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
 */
public data class RuleRuleConditionHeaderConfigArgs(
    public val key: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionHeaderConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionHeaderConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionHeaderConfigArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleRuleConditionHeaderConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionHeaderConfigArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("qatjesuihhijcxup")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("unkduvblppdicuwy")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("opgmwfjphdbysmro")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("rfultkkufonutkug")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("noqihcbfbnhscqoi")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("cxnenimvvnusuadm")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("yyuxpykyxvodfaqk")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): RuleRuleConditionHeaderConfigArgs = RuleRuleConditionHeaderConfigArgs(
        key = key,
        values = values,
    )
}
