@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionPathConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
 */
public data class RuleRuleConditionPathConfigArgs(
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionPathConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionPathConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionPathConfigArgs.builder()
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleRuleConditionPathConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionPathConfigArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("rfpudsklfqqmyphj")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("avjnsowamisycmwj")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("rchbdblsodahrbvs")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("imdkbqujieivvcnl")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("gkrqybmgltbncmiq")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): RuleRuleConditionPathConfigArgs = RuleRuleConditionPathConfigArgs(
        values = values,
    )
}
