@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionQueryStringConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
 */
public data class RuleRuleConditionQueryStringConfigArgs(
    public val values: Output<List<RuleRuleConditionQueryStringConfigValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionQueryStringConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionQueryStringConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionQueryStringConfigArgs.builder()
            .values(
                values?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleRuleConditionQueryStringConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionQueryStringConfigArgsBuilder internal constructor() {
    private var values: Output<List<RuleRuleConditionQueryStringConfigValueArgs>>? = null

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ariirjmpaypufaum")
    public suspend fun values(`value`: Output<List<RuleRuleConditionQueryStringConfigValueArgs>>) {
        this.values = value
    }

    @JvmName("munvafyoyqvkufqp")
    public suspend fun values(vararg values: Output<RuleRuleConditionQueryStringConfigValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("wdifkgirxikpkmlv")
    public suspend fun values(values: List<Output<RuleRuleConditionQueryStringConfigValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ewkiframgqhixuto")
    public suspend fun values(`value`: List<RuleRuleConditionQueryStringConfigValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("eqyfrjgppytkmgrc")
    public suspend fun values(argument: List<suspend RuleRuleConditionQueryStringConfigValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionQueryStringConfigValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("nhigsewcnorgemum")
    public suspend fun values(vararg argument: suspend RuleRuleConditionQueryStringConfigValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionQueryStringConfigValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("ogakedisghlvcwwx")
    public suspend fun values(argument: suspend RuleRuleConditionQueryStringConfigValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleRuleConditionQueryStringConfigValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("mihlobxjfunwbhfr")
    public suspend fun values(vararg values: RuleRuleConditionQueryStringConfigValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): RuleRuleConditionQueryStringConfigArgs =
        RuleRuleConditionQueryStringConfigArgs(
            values = values,
        )
}
