@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.RuleRuleConditionResponseHeaderConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
 */
public data class RuleRuleConditionResponseHeaderConfigArgs(
    public val key: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.RuleRuleConditionResponseHeaderConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.RuleRuleConditionResponseHeaderConfigArgs =
        com.pulumi.alicloud.alb.inputs.RuleRuleConditionResponseHeaderConfigArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleRuleConditionResponseHeaderConfigArgs].
 */
@PulumiTagMarker
public class RuleRuleConditionResponseHeaderConfigArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("osrqjwpfecbtrpee")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("bymbxudxmeqaovyd")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("texjnfylybgqbgfp")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("xwcskvcbnnctwqpv")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wjrqatbprrknmqjb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("avugngyeokxfcfqg")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Add one or more IP addresses or IP address segments. You can add up to 5 forwarding rules in a SourceIp.
     */
    @JvmName("wwdyosginfuvnkus")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): RuleRuleConditionResponseHeaderConfigArgs =
        RuleRuleConditionResponseHeaderConfigArgs(
            key = key,
            values = values,
        )
}
