@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property healthCheckCodes The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
 * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
 * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
 * @property healthCheckConnectPort The backend port that is used for health checks. Default value: `0`. Valid values: `0` to `65535`. A value of 0 indicates that a backend server port is used for health checks.
 * @property healthCheckEnabled Specifies whether to enable the health check feature. Valid values: `true`, `false`.
 * @property healthCheckHost The domain name that is used for health checks.
 * @property healthCheckHttpVersion The version of the HTTP protocol. Default value: `HTTP1.1`. Valid values: `HTTP1.0` and `HTTP1.1`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
 * @property healthCheckInterval The interval at which health checks are performed. Unit: seconds. Default value: `2`. Valid values: `1` to `50`.
 * @property healthCheckMethod The HTTP method that is used for health checks. Default value: `GET`. Valid values: `GET`, `POST`, `HEAD`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP`, `HTTPS`, or `gRPC`. From version 1.215.0, `health_check_method` can be set to `POST`.
 * @property healthCheckPath The path that is used for health checks. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
 * @property healthCheckProtocol The protocol that is used for health checks. Valid values: `HTTP`, `HTTPS`, `TCP` and `gRPC`.
 * @property healthCheckTimeout The timeout period for a health check response. If a backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the ECS instance is considered unhealthy. Unit: seconds. Default value: `5`. Valid values: `1` to `300`. **NOTE:** If the value of `health_check_timeout` is smaller than the value of `health_check_interval`, the value of `health_check_timeout` is ignored and the value of `health_check_interval` is used.
 * @property healthyThreshold The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. Default value: `3`. Valid values: `2` to `10`.
 * @property unhealthyThreshold The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. Default value: `3`. Valid values: `2` to `10`.
 */
public data class ServerGroupHealthCheckConfigArgs(
    public val healthCheckCodes: Output<List<String>>? = null,
    public val healthCheckConnectPort: Output<Int>? = null,
    public val healthCheckEnabled: Output<Boolean>,
    public val healthCheckHost: Output<String>? = null,
    public val healthCheckHttpVersion: Output<String>? = null,
    public val healthCheckInterval: Output<Int>? = null,
    public val healthCheckMethod: Output<String>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val healthCheckProtocol: Output<String>? = null,
    public val healthCheckTimeout: Output<Int>? = null,
    public val healthyThreshold: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs =
        com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs.builder()
            .healthCheckCodes(healthCheckCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckConnectPort(healthCheckConnectPort?.applyValue({ args0 -> args0 }))
            .healthCheckEnabled(healthCheckEnabled.applyValue({ args0 -> args0 }))
            .healthCheckHost(healthCheckHost?.applyValue({ args0 -> args0 }))
            .healthCheckHttpVersion(healthCheckHttpVersion?.applyValue({ args0 -> args0 }))
            .healthCheckInterval(healthCheckInterval?.applyValue({ args0 -> args0 }))
            .healthCheckMethod(healthCheckMethod?.applyValue({ args0 -> args0 }))
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .healthCheckProtocol(healthCheckProtocol?.applyValue({ args0 -> args0 }))
            .healthCheckTimeout(healthCheckTimeout?.applyValue({ args0 -> args0 }))
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class ServerGroupHealthCheckConfigArgsBuilder internal constructor() {
    private var healthCheckCodes: Output<List<String>>? = null

    private var healthCheckConnectPort: Output<Int>? = null

    private var healthCheckEnabled: Output<Boolean>? = null

    private var healthCheckHost: Output<String>? = null

    private var healthCheckHttpVersion: Output<String>? = null

    private var healthCheckInterval: Output<Int>? = null

    private var healthCheckMethod: Output<String>? = null

    private var healthCheckPath: Output<String>? = null

    private var healthCheckProtocol: Output<String>? = null

    private var healthCheckTimeout: Output<Int>? = null

    private var healthyThreshold: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
     * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
     * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
     */
    @JvmName("yokxmioriwpqccyx")
    public suspend fun healthCheckCodes(`value`: Output<List<String>>) {
        this.healthCheckCodes = value
    }

    @JvmName("jysspkkujyrjhhwv")
    public suspend fun healthCheckCodes(vararg values: Output<String>) {
        this.healthCheckCodes = Output.all(values.asList())
    }

    /**
     * @param values The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
     * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
     * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
     */
    @JvmName("khjrgaomuouuanbr")
    public suspend fun healthCheckCodes(values: List<Output<String>>) {
        this.healthCheckCodes = Output.all(values)
    }

    /**
     * @param value The backend port that is used for health checks. Default value: `0`. Valid values: `0` to `65535`. A value of 0 indicates that a backend server port is used for health checks.
     */
    @JvmName("domrnthqqibbgoll")
    public suspend fun healthCheckConnectPort(`value`: Output<Int>) {
        this.healthCheckConnectPort = value
    }

    /**
     * @param value Specifies whether to enable the health check feature. Valid values: `true`, `false`.
     */
    @JvmName("lcjxlsmijrtxwyja")
    public suspend fun healthCheckEnabled(`value`: Output<Boolean>) {
        this.healthCheckEnabled = value
    }

    /**
     * @param value The domain name that is used for health checks.
     */
    @JvmName("dphunpelephbfiap")
    public suspend fun healthCheckHost(`value`: Output<String>) {
        this.healthCheckHost = value
    }

    /**
     * @param value The version of the HTTP protocol. Default value: `HTTP1.1`. Valid values: `HTTP1.0` and `HTTP1.1`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
     */
    @JvmName("iqsgwcxwcgybwjau")
    public suspend fun healthCheckHttpVersion(`value`: Output<String>) {
        this.healthCheckHttpVersion = value
    }

    /**
     * @param value The interval at which health checks are performed. Unit: seconds. Default value: `2`. Valid values: `1` to `50`.
     */
    @JvmName("ekwhocigwpcwdvtd")
    public suspend fun healthCheckInterval(`value`: Output<Int>) {
        this.healthCheckInterval = value
    }

    /**
     * @param value The HTTP method that is used for health checks. Default value: `GET`. Valid values: `GET`, `POST`, `HEAD`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP`, `HTTPS`, or `gRPC`. From version 1.215.0, `health_check_method` can be set to `POST`.
     */
    @JvmName("yabdgtjpemnjhkhf")
    public suspend fun healthCheckMethod(`value`: Output<String>) {
        this.healthCheckMethod = value
    }

    /**
     * @param value The path that is used for health checks. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
     */
    @JvmName("gbjtvhmxemlndouq")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value The protocol that is used for health checks. Valid values: `HTTP`, `HTTPS`, `TCP` and `gRPC`.
     */
    @JvmName("tudckeedchlicoev")
    public suspend fun healthCheckProtocol(`value`: Output<String>) {
        this.healthCheckProtocol = value
    }

    /**
     * @param value The timeout period for a health check response. If a backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the ECS instance is considered unhealthy. Unit: seconds. Default value: `5`. Valid values: `1` to `300`. **NOTE:** If the value of `health_check_timeout` is smaller than the value of `health_check_interval`, the value of `health_check_timeout` is ignored and the value of `health_check_interval` is used.
     */
    @JvmName("awqppafmabcfjouo")
    public suspend fun healthCheckTimeout(`value`: Output<Int>) {
        this.healthCheckTimeout = value
    }

    /**
     * @param value The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. Default value: `3`. Valid values: `2` to `10`.
     */
    @JvmName("gbxwfheewwevtnhh")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. Default value: `3`. Valid values: `2` to `10`.
     */
    @JvmName("lfxcrnfgadkgeijh")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
     * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
     * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
     */
    @JvmName("srqicfnsnkwprbrv")
    public suspend fun healthCheckCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckCodes = mapped
    }

    /**
     * @param values The HTTP status codes that are used to indicate whether the backend server passes the health check. Valid values:
     * - If `health_check_protocol` is set to `HTTP` or `HTTPS`. Valid values: `http_2xx`, `http_3xx`, `http_4xx`, and `http_5xx`. Default value: `http_2xx`.
     * - If `health_check_protocol` is set to `gRPC`. Valid values: `0` to `99`. Default value: `0`.
     */
    @JvmName("opussvhmbeoajbaa")
    public suspend fun healthCheckCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckCodes = mapped
    }

    /**
     * @param value The backend port that is used for health checks. Default value: `0`. Valid values: `0` to `65535`. A value of 0 indicates that a backend server port is used for health checks.
     */
    @JvmName("ulabkctmuilnccyn")
    public suspend fun healthCheckConnectPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConnectPort = mapped
    }

    /**
     * @param value Specifies whether to enable the health check feature. Valid values: `true`, `false`.
     */
    @JvmName("vyprtfaisntedfxv")
    public suspend fun healthCheckEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckEnabled = mapped
    }

    /**
     * @param value The domain name that is used for health checks.
     */
    @JvmName("qechtlddbmybjpfd")
    public suspend fun healthCheckHost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHost = mapped
    }

    /**
     * @param value The version of the HTTP protocol. Default value: `HTTP1.1`. Valid values: `HTTP1.0` and `HTTP1.1`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
     */
    @JvmName("rmdybqmoqmkxmddx")
    public suspend fun healthCheckHttpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHttpVersion = mapped
    }

    /**
     * @param value The interval at which health checks are performed. Unit: seconds. Default value: `2`. Valid values: `1` to `50`.
     */
    @JvmName("fdegjyoafbujuchf")
    public suspend fun healthCheckInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckInterval = mapped
    }

    /**
     * @param value The HTTP method that is used for health checks. Default value: `GET`. Valid values: `GET`, `POST`, `HEAD`. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP`, `HTTPS`, or `gRPC`. From version 1.215.0, `health_check_method` can be set to `POST`.
     */
    @JvmName("muexiwatuvpdsmov")
    public suspend fun healthCheckMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckMethod = mapped
    }

    /**
     * @param value The path that is used for health checks. **NOTE:** This parameter takes effect only when `health_check_protocol` is set to `HTTP` or `HTTPS`.
     */
    @JvmName("tcmdecvwojmtafuf")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value The protocol that is used for health checks. Valid values: `HTTP`, `HTTPS`, `TCP` and `gRPC`.
     */
    @JvmName("rwihryqenhormfpk")
    public suspend fun healthCheckProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckProtocol = mapped
    }

    /**
     * @param value The timeout period for a health check response. If a backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the ECS instance is considered unhealthy. Unit: seconds. Default value: `5`. Valid values: `1` to `300`. **NOTE:** If the value of `health_check_timeout` is smaller than the value of `health_check_interval`, the value of `health_check_timeout` is ignored and the value of `health_check_interval` is used.
     */
    @JvmName("pyywqnbkwisvvhmu")
    public suspend fun healthCheckTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTimeout = mapped
    }

    /**
     * @param value The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. Default value: `3`. Valid values: `2` to `10`.
     */
    @JvmName("btoadsqaunlotpfy")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. Default value: `3`. Valid values: `2` to `10`.
     */
    @JvmName("mrxmqtwfexyyvlin")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): ServerGroupHealthCheckConfigArgs = ServerGroupHealthCheckConfigArgs(
        healthCheckCodes = healthCheckCodes,
        healthCheckConnectPort = healthCheckConnectPort,
        healthCheckEnabled = healthCheckEnabled ?: throw PulumiNullFieldException("healthCheckEnabled"),
        healthCheckHost = healthCheckHost,
        healthCheckHttpVersion = healthCheckHttpVersion,
        healthCheckInterval = healthCheckInterval,
        healthCheckMethod = healthCheckMethod,
        healthCheckPath = healthCheckPath,
        healthCheckProtocol = healthCheckProtocol,
        healthCheckTimeout = healthCheckTimeout,
        healthyThreshold = healthyThreshold,
        unhealthyThreshold = unhealthyThreshold,
    )
}
