@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ServerGroupServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the backend server.
 * @property port The port used by the backend server. Valid values: `1` to `65535`. **Note:** This parameter is required if the `server_type` parameter is set to `Ecs`, `Eni`, `Eci`, or `Ip`. You do not need to configure this parameter if you set `server_type` to `Fc`.
 * @property remoteIpEnabled Specifies whether to enable the remote IP address feature. You can specify up to 40 servers in each call. **Note:** If `server_type` is set to `Ip`, this parameter is available.
 * @property serverId The ID of the backend server.
 * - If `server_group_type` is set to `Instance`, set the parameter to the ID of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. These backend servers are specified by Ecs, Eni, or Eci.
 * - If `server_group_type` is set to `Ip`, set the parameter to an IP address specified in the server group.
 * - If `server_group_type` is set to `Fc`, set the parameter to the Alibaba Cloud Resource Name (ARN) of a function specified in the server group.
 * @property serverIp The IP address of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. **Note:** If `server_group_type` is set to `Fc`, you do not need to configure parameters, otherwise this attribute is required. If `server_group_type` is set to `Ip`, the value of this property is the same as the `server_id` value.
 * @property serverType The type of the server. The type of the server. Valid values:
 * - `Ecs`: an ECS instance.
 * - `Eni`: an ENI.
 * - `Eci`: an elastic container instance.
 * - `Ip`(Available since v1.194.0): an IP address.
 * - `Fc`(Available since v1.194.0): a function.
 * @property status The status of the backend server.
 * @property weight The weight of the server. Default value: `100`. Valid values: `0` to `100`. If the value is set to `0`, no requests are forwarded to the server. **Note:** You do not need to set this parameter if you set `server_type` to `Fc`.
 */
public data class ServerGroupServerArgs(
    public val description: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val remoteIpEnabled: Output<Boolean>? = null,
    public val serverId: Output<String>,
    public val serverIp: Output<String>? = null,
    public val serverType: Output<String>,
    public val status: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ServerGroupServerArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ServerGroupServerArgs =
        com.pulumi.alicloud.alb.inputs.ServerGroupServerArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .remoteIpEnabled(remoteIpEnabled?.applyValue({ args0 -> args0 }))
            .serverId(serverId.applyValue({ args0 -> args0 }))
            .serverIp(serverIp?.applyValue({ args0 -> args0 }))
            .serverType(serverType.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupServerArgs].
 */
@PulumiTagMarker
public class ServerGroupServerArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var port: Output<Int>? = null

    private var remoteIpEnabled: Output<Boolean>? = null

    private var serverId: Output<String>? = null

    private var serverIp: Output<String>? = null

    private var serverType: Output<String>? = null

    private var status: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The description of the backend server.
     */
    @JvmName("oueijydifhkhamub")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The port used by the backend server. Valid values: `1` to `65535`. **Note:** This parameter is required if the `server_type` parameter is set to `Ecs`, `Eni`, `Eci`, or `Ip`. You do not need to configure this parameter if you set `server_type` to `Fc`.
     */
    @JvmName("pchyusytestleubu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Specifies whether to enable the remote IP address feature. You can specify up to 40 servers in each call. **Note:** If `server_type` is set to `Ip`, this parameter is available.
     */
    @JvmName("soxdqxivddmmkfwi")
    public suspend fun remoteIpEnabled(`value`: Output<Boolean>) {
        this.remoteIpEnabled = value
    }

    /**
     * @param value The ID of the backend server.
     * - If `server_group_type` is set to `Instance`, set the parameter to the ID of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. These backend servers are specified by Ecs, Eni, or Eci.
     * - If `server_group_type` is set to `Ip`, set the parameter to an IP address specified in the server group.
     * - If `server_group_type` is set to `Fc`, set the parameter to the Alibaba Cloud Resource Name (ARN) of a function specified in the server group.
     */
    @JvmName("uljbahhehhabjmee")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value The IP address of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. **Note:** If `server_group_type` is set to `Fc`, you do not need to configure parameters, otherwise this attribute is required. If `server_group_type` is set to `Ip`, the value of this property is the same as the `server_id` value.
     */
    @JvmName("grebtdevjxsdxyfj")
    public suspend fun serverIp(`value`: Output<String>) {
        this.serverIp = value
    }

    /**
     * @param value The type of the server. The type of the server. Valid values:
     * - `Ecs`: an ECS instance.
     * - `Eni`: an ENI.
     * - `Eci`: an elastic container instance.
     * - `Ip`(Available since v1.194.0): an IP address.
     * - `Fc`(Available since v1.194.0): a function.
     */
    @JvmName("kfbvxxmypetcupcs")
    public suspend fun serverType(`value`: Output<String>) {
        this.serverType = value
    }

    /**
     * @param value The status of the backend server.
     */
    @JvmName("cqkmkdrtosheeoba")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The weight of the server. Default value: `100`. Valid values: `0` to `100`. If the value is set to `0`, no requests are forwarded to the server. **Note:** You do not need to set this parameter if you set `server_type` to `Fc`.
     */
    @JvmName("abivlfdbeoakaisc")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The description of the backend server.
     */
    @JvmName("bipydytbugugusyg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The port used by the backend server. Valid values: `1` to `65535`. **Note:** This parameter is required if the `server_type` parameter is set to `Ecs`, `Eni`, `Eci`, or `Ip`. You do not need to configure this parameter if you set `server_type` to `Fc`.
     */
    @JvmName("tsgyujqmybkulbjy")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Specifies whether to enable the remote IP address feature. You can specify up to 40 servers in each call. **Note:** If `server_type` is set to `Ip`, this parameter is available.
     */
    @JvmName("tijiismcasswwjnq")
    public suspend fun remoteIpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteIpEnabled = mapped
    }

    /**
     * @param value The ID of the backend server.
     * - If `server_group_type` is set to `Instance`, set the parameter to the ID of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. These backend servers are specified by Ecs, Eni, or Eci.
     * - If `server_group_type` is set to `Ip`, set the parameter to an IP address specified in the server group.
     * - If `server_group_type` is set to `Fc`, set the parameter to the Alibaba Cloud Resource Name (ARN) of a function specified in the server group.
     */
    @JvmName("nwoqyyqvyvgdwxij")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value The IP address of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. **Note:** If `server_group_type` is set to `Fc`, you do not need to configure parameters, otherwise this attribute is required. If `server_group_type` is set to `Ip`, the value of this property is the same as the `server_id` value.
     */
    @JvmName("qbyinqiagifxgcfn")
    public suspend fun serverIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverIp = mapped
    }

    /**
     * @param value The type of the server. The type of the server. Valid values:
     * - `Ecs`: an ECS instance.
     * - `Eni`: an ENI.
     * - `Eci`: an elastic container instance.
     * - `Ip`(Available since v1.194.0): an IP address.
     * - `Fc`(Available since v1.194.0): a function.
     */
    @JvmName("ljonfhneijhmkhbb")
    public suspend fun serverType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value The status of the backend server.
     */
    @JvmName("fgwvjtkxhyseuniy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The weight of the server. Default value: `100`. Valid values: `0` to `100`. If the value is set to `0`, no requests are forwarded to the server. **Note:** You do not need to set this parameter if you set `server_type` to `Fc`.
     */
    @JvmName("jlnsmeypbjjyqkjp")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ServerGroupServerArgs = ServerGroupServerArgs(
        description = description,
        port = port,
        remoteIpEnabled = remoteIpEnabled,
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
        serverIp = serverIp,
        serverType = serverType ?: throw PulumiNullFieldException("serverType"),
        status = status,
        weight = weight,
    )
}
