@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cookie The cookie to be configured on the server. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Server`.
 * @property cookieTimeout The timeout period of a cookie. Unit: seconds. Default value: `1000`. Valid values: `1` to `86400`. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Insert`.
 * @property stickySessionEnabled Specifies whether to enable session persistence. Default value: `false`. Valid values: `true`, `false`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
 * @property stickySessionType The method that is used to handle a cookie. Valid values: `Server`, `Insert`.
 */
public data class ServerGroupStickySessionConfigArgs(
    public val cookie: Output<String>? = null,
    public val cookieTimeout: Output<Int>? = null,
    public val stickySessionEnabled: Output<Boolean>? = null,
    public val stickySessionType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs =
        com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs.builder()
            .cookie(cookie?.applyValue({ args0 -> args0 }))
            .cookieTimeout(cookieTimeout?.applyValue({ args0 -> args0 }))
            .stickySessionEnabled(stickySessionEnabled?.applyValue({ args0 -> args0 }))
            .stickySessionType(stickySessionType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupStickySessionConfigArgs].
 */
@PulumiTagMarker
public class ServerGroupStickySessionConfigArgsBuilder internal constructor() {
    private var cookie: Output<String>? = null

    private var cookieTimeout: Output<Int>? = null

    private var stickySessionEnabled: Output<Boolean>? = null

    private var stickySessionType: Output<String>? = null

    /**
     * @param value The cookie to be configured on the server. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Server`.
     */
    @JvmName("dclkeyoterrnuwef")
    public suspend fun cookie(`value`: Output<String>) {
        this.cookie = value
    }

    /**
     * @param value The timeout period of a cookie. Unit: seconds. Default value: `1000`. Valid values: `1` to `86400`. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Insert`.
     */
    @JvmName("nxidtvoawswqnpxw")
    public suspend fun cookieTimeout(`value`: Output<Int>) {
        this.cookieTimeout = value
    }

    /**
     * @param value Specifies whether to enable session persistence. Default value: `false`. Valid values: `true`, `false`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("jyejfaqvknaabidh")
    public suspend fun stickySessionEnabled(`value`: Output<Boolean>) {
        this.stickySessionEnabled = value
    }

    /**
     * @param value The method that is used to handle a cookie. Valid values: `Server`, `Insert`.
     */
    @JvmName("hsfuoyvjxlvrexqo")
    public suspend fun stickySessionType(`value`: Output<String>) {
        this.stickySessionType = value
    }

    /**
     * @param value The cookie to be configured on the server. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Server`.
     */
    @JvmName("rejpooxyilaqajmg")
    public suspend fun cookie(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookie = mapped
    }

    /**
     * @param value The timeout period of a cookie. Unit: seconds. Default value: `1000`. Valid values: `1` to `86400`. **NOTE:** This parameter takes effect when the `sticky_session_enabled` parameter is set to `true` and the `sticky_session_type` parameter is set to `Insert`.
     */
    @JvmName("tpgskfjrnexdepwx")
    public suspend fun cookieTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieTimeout = mapped
    }

    /**
     * @param value Specifies whether to enable session persistence. Default value: `false`. Valid values: `true`, `false`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("qgmfodgyclkxqdqr")
    public suspend fun stickySessionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickySessionEnabled = mapped
    }

    /**
     * @param value The method that is used to handle a cookie. Valid values: `Server`, `Insert`.
     */
    @JvmName("ysfrmlciacfgqyjh")
    public suspend fun stickySessionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickySessionType = mapped
    }

    internal fun build(): ServerGroupStickySessionConfigArgs = ServerGroupStickySessionConfigArgs(
        cookie = cookie,
        cookieTimeout = cookieTimeout,
        stickySessionEnabled = stickySessionEnabled,
        stickySessionType = stickySessionType,
    )
}
