@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the ACL entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_). It can also contain Chinese characters.
 * @property entry The IP address for the ACL entry.
 * @property status The status of the ACL entry. Valid values:
 * - `Adding`: The ACL entry is being added.
 * - `Available`: The ACL entry is added and available.
 * - `Removing`: The ACL entry is being removed.
 */
public data class AclAclEntry(
    public val description: String? = null,
    public val entry: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.AclAclEntry): AclAclEntry =
            AclAclEntry(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                entry = javaType.entry().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
