@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclEntries ACL Entries.
 * @property aclId Access Control Policy ID.
 * @property aclName The ACL Name.
 * @property addressIpVersion Address Protocol Version.
 * @property id The ID of the Acl.
 * @property resourceGroupId Resource Group to Which the Number.
 * @property status The state of the ACL. Valid values:`Provisioning` , `Available` and `Configuring`. `Provisioning`: The ACL is being created. `Available`: The ACL is available. `Configuring`: The ACL is being configured.
 */
public data class GetAclsAcl(
    public val aclEntries: List<GetAclsAclAclEntry>,
    public val aclId: String,
    public val aclName: String,
    public val addressIpVersion: String,
    public val id: String,
    public val resourceGroupId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetAclsAcl): GetAclsAcl =
            GetAclsAcl(
                aclEntries = javaType.aclEntries().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.GetAclsAclAclEntry.Companion.toKotlin(args0)
                    })
                }),
                aclId = javaType.aclId(),
                aclName = javaType.aclName(),
                addressIpVersion = javaType.addressIpVersion(),
                id = javaType.id(),
                resourceGroupId = javaType.resourceGroupId(),
                status = javaType.status(),
            )
    }
}
