@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ascriptId Script identification.
 * @property ascriptName Script name.
 * @property enabled Whether scripts are enabled.
 * @property extAttributeEnabled Whether extension parameters are enabled.
 * @property extAttributes Extended attribute list.
 * @property id
 * @property listenerId Listener ID of script attribution
 * @property loadBalancerId
 * @property position Script execution location.
 * @property scriptContent Script content.
 * @property status Script status.
 */
public data class GetAscriptsAscript(
    public val ascriptId: String,
    public val ascriptName: String,
    public val enabled: Boolean,
    public val extAttributeEnabled: Boolean,
    public val extAttributes: List<GetAscriptsAscriptExtAttribute>,
    public val id: String,
    public val listenerId: String,
    public val loadBalancerId: String,
    public val position: String,
    public val scriptContent: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetAscriptsAscript): GetAscriptsAscript = GetAscriptsAscript(
            ascriptId = javaType.ascriptId(),
            ascriptName = javaType.ascriptName(),
            enabled = javaType.enabled(),
            extAttributeEnabled = javaType.extAttributeEnabled(),
            extAttributes = javaType.extAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetAscriptsAscriptExtAttribute.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
            loadBalancerId = javaType.loadBalancerId(),
            position = javaType.position(),
            scriptContent = javaType.scriptContent(),
            status = javaType.status(),
        )
    }
}
