@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAscripts.
 * @property ascriptName Script name.
 * @property ascripts A list of AScript Entries. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of AScript IDs.
 * @property listenerId Listener ID of script attribution.
 * @property nameRegex
 * @property names A list of name of AScripts.
 * @property outputFile
 */
public data class GetAscriptsResult(
    public val ascriptName: String? = null,
    public val ascripts: List<GetAscriptsAscript>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetAscriptsResult): GetAscriptsResult = GetAscriptsResult(
            ascriptName = javaType.ascriptName().map({ args0 -> args0 }).orElse(null),
            ascripts = javaType.ascripts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetAscriptsAscript.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
