@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHealthCheckTemplates.
 * @property healthCheckTemplateIds
 * @property healthCheckTemplateName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property templates
 */
public data class GetHealthCheckTemplatesResult(
    public val healthCheckTemplateIds: List<String>? = null,
    public val healthCheckTemplateName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val templates: List<GetHealthCheckTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetHealthCheckTemplatesResult): GetHealthCheckTemplatesResult = GetHealthCheckTemplatesResult(
            healthCheckTemplateIds = javaType.healthCheckTemplateIds().map({ args0 -> args0 }),
            healthCheckTemplateName = javaType.healthCheckTemplateName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetHealthCheckTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
