@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property healthCheckCodes The HTTP status code that indicates a successful health check.
 * @property healthCheckConnectPort The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value:` 0`. This default value indicates that the backend server is used for health checks.
 * @property healthCheckHost The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.
 * @property healthCheckHttpVersion The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`.
 * @property healthCheckInterval The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
 * @property healthCheckMethod The health check method.  Valid values: `GET` and `HEAD`.  Default value: `HEAD`.
 * @property healthCheckPath The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: ` _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/)`.
 * @property healthCheckProtocol The protocol that is used for health checks.  Valid values: HTTP and TCP.  Default value: HTTP.
 * @property healthCheckTemplateId The ID of the resource.
 * @property healthCheckTemplateName The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 * @property healthCheckTimeout The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
 * @property healthyThreshold The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
 * @property id The ID of the Health Check Template.
 * @property unhealthyThreshold The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
 */
public data class GetHealthCheckTemplatesTemplate(
    public val healthCheckCodes: List<String>,
    public val healthCheckConnectPort: Int,
    public val healthCheckHost: String,
    public val healthCheckHttpVersion: String,
    public val healthCheckInterval: Int,
    public val healthCheckMethod: String,
    public val healthCheckPath: String,
    public val healthCheckProtocol: String,
    public val healthCheckTemplateId: String,
    public val healthCheckTemplateName: String,
    public val healthCheckTimeout: Int,
    public val healthyThreshold: Int,
    public val id: String,
    public val unhealthyThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetHealthCheckTemplatesTemplate): GetHealthCheckTemplatesTemplate = GetHealthCheckTemplatesTemplate(
            healthCheckCodes = javaType.healthCheckCodes().map({ args0 -> args0 }),
            healthCheckConnectPort = javaType.healthCheckConnectPort(),
            healthCheckHost = javaType.healthCheckHost(),
            healthCheckHttpVersion = javaType.healthCheckHttpVersion(),
            healthCheckInterval = javaType.healthCheckInterval(),
            healthCheckMethod = javaType.healthCheckMethod(),
            healthCheckPath = javaType.healthCheckPath(),
            healthCheckProtocol = javaType.healthCheckProtocol(),
            healthCheckTemplateId = javaType.healthCheckTemplateId(),
            healthCheckTemplateName = javaType.healthCheckTemplateName(),
            healthCheckTimeout = javaType.healthCheckTimeout(),
            healthyThreshold = javaType.healthyThreshold(),
            id = javaType.id(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
        )
    }
}
