@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessLogRecordCustomizedHeadersEnabled Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
 * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
 * @property accessLogTracingConfigs Xtrace Configuration Information.
 * @property aclConfigs The configurations of the access control lists (ACLs).
 * @property certificates The Certificate List.
 * @property defaultActions The Default Rule Action List.
 * @property gzipEnabled Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: `True` Or `False`. Default Value: `True`.
 * @property http2Enabled Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
 * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
 * @property id The ID of the Listener.
 * @property idleTimeout Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
 * @property listenerDescription Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
 * @property listenerId on Behalf of the Resource Level Id of the Resources Property Fields.
 * @property listenerPort The ALB Instance Front-End, and Those of the Ports Used. Value: `1~65535`.
 * @property listenerProtocol Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
 * @property loadBalancerId The ALB Instance Id.
 * @property maxResults This Request Returned by the Maximum Number of Records.
 * @property nextToken The Current Call Returns to the Position of the Set to Null Represents the Data Has Been Read to the End of.
 * @property quicConfigs Configuration Associated with the QuIC Listening.
 * @property requestTimeout The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: 60. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
 * @property securityPolicyId Security Policy.
 * > **NOTE:** The attribute is valid when the attribute `ListenerProtocol` is `HTTPS`.
 * @property status The state of the listener. Valid Values: `Running` Or `Stopped`. `Running`: The listener is running. `Stopped`: The listener is stopped.
 * @property xforwardedForConfigs xforwardfor Related Attribute Configuration.
 */
public data class GetListenersListener(
    public val accessLogRecordCustomizedHeadersEnabled: Boolean,
    public val accessLogTracingConfigs: List<GetListenersListenerAccessLogTracingConfig>,
    public val aclConfigs: List<GetListenersListenerAclConfig>,
    public val certificates: List<GetListenersListenerCertificate>,
    public val defaultActions: List<GetListenersListenerDefaultAction>,
    public val gzipEnabled: Boolean,
    public val http2Enabled: Boolean,
    public val id: String,
    public val idleTimeout: Int,
    public val listenerDescription: String,
    public val listenerId: String,
    public val listenerPort: Int,
    public val listenerProtocol: String,
    public val loadBalancerId: String,
    public val maxResults: String,
    public val nextToken: String,
    public val quicConfigs: List<GetListenersListenerQuicConfig>,
    public val requestTimeout: Int,
    public val securityPolicyId: String,
    public val status: String,
    public val xforwardedForConfigs: List<GetListenersListenerXforwardedForConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListener): GetListenersListener = GetListenersListener(
            accessLogRecordCustomizedHeadersEnabled = javaType.accessLogRecordCustomizedHeadersEnabled(),
            accessLogTracingConfigs = javaType.accessLogTracingConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerAccessLogTracingConfig.Companion.toKotlin(args0)
                })
            }),
            aclConfigs = javaType.aclConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerAclConfig.Companion.toKotlin(args0)
                })
            }),
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerCertificate.Companion.toKotlin(args0)
                })
            }),
            defaultActions = javaType.defaultActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerDefaultAction.Companion.toKotlin(args0)
                })
            }),
            gzipEnabled = javaType.gzipEnabled(),
            http2Enabled = javaType.http2Enabled(),
            id = javaType.id(),
            idleTimeout = javaType.idleTimeout(),
            listenerDescription = javaType.listenerDescription(),
            listenerId = javaType.listenerId(),
            listenerPort = javaType.listenerPort(),
            listenerProtocol = javaType.listenerProtocol(),
            loadBalancerId = javaType.loadBalancerId(),
            maxResults = javaType.maxResults(),
            nextToken = javaType.nextToken(),
            quicConfigs = javaType.quicConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerQuicConfig.Companion.toKotlin(args0)
                })
            }),
            requestTimeout = javaType.requestTimeout(),
            securityPolicyId = javaType.securityPolicyId(),
            status = javaType.status(),
            xforwardedForConfigs = javaType.xforwardedForConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerXforwardedForConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
