@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tracingEnabled Xtrace Function. Value: True Or False. Default Value: False.
 * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
 * @property tracingSample Xtrace Sampling Rate. Value: **1~10000**.
 * > **NOTE:** This attribute is valid when **tracingenabled** is **true**.
 * @property tracingType Xtrace Type Value Is **Zipkin**.
 * > **NOTE:** This attribute is valid when **tracingenabled** is **true**.
 */
public data class GetListenersListenerAccessLogTracingConfig(
    public val tracingEnabled: Boolean,
    public val tracingSample: Int,
    public val tracingType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListenerAccessLogTracingConfig): GetListenersListenerAccessLogTracingConfig = GetListenersListenerAccessLogTracingConfig(
            tracingEnabled = javaType.tracingEnabled(),
            tracingSample = javaType.tracingSample(),
            tracingType = javaType.tracingType(),
        )
    }
}
