@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aclId Snooping Binding of the Access Policy Group ID List.
 * @property status The association status between the ACL and the listener.  Valid values: `Associating`, `Associated` Or `Dissociating`. `Associating`: The ACL is being associated with the listener. `Associated`: The ACL is associated with the listener. `Dissociating`: The ACL is being disassociated from the listener.
 */
public data class GetListenersListenerAclConfigAclRelation(
    public val aclId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListenerAclConfigAclRelation): GetListenersListenerAclConfigAclRelation = GetListenersListenerAclConfigAclRelation(
            aclId = javaType.aclId(),
            status = javaType.status(),
        )
    }
}
