@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property forwardGroupConfigs The configuration of the forwarding rule action. This parameter is required if the Type parameter is set to FowardGroup.
 * @property type Action Type. The value is set to ForwardGroup. It indicates that requests are forwarded to multiple vServer groups.
 */
public data class GetListenersListenerDefaultAction(
    public val forwardGroupConfigs: List<GetListenersListenerDefaultActionForwardGroupConfig>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListenerDefaultAction): GetListenersListenerDefaultAction = GetListenersListenerDefaultAction(
            forwardGroupConfigs = javaType.forwardGroupConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListenerDefaultActionForwardGroupConfig.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
