@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property quicListenerId The ID of the QUIC listener to be associated. If QuicUpgradeEnabled is set to true, this parameter is required. Only HTTPS listeners support this parameter.
 * @property quicUpgradeEnabled Indicates whether quic upgrade is enabled. Valid values: true and false. Default value: false.
 */
public data class GetListenersListenerQuicConfig(
    public val quicListenerId: String,
    public val quicUpgradeEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListenerQuicConfig): GetListenersListenerQuicConfig = GetListenersListenerQuicConfig(
            quicListenerId = javaType.quicListenerId(),
            quicUpgradeEnabled = javaType.quicUpgradeEnabled(),
        )
    }
}
