@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property xforwardedforclientcertIssuerdnalias The Custom Header Field Names Only When `xforwardedforclientcert_issuerdnenabled`, Which Evaluates to True When the Entry into Force of.
 * @property xforwardedforclientcertIssuerdnenabled Indicates Whether the `X-Forwarded-Clientcert-issuerdn` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate after the Manifests Are Signed, the Publisher Information.
 * @property xforwardedforclientcertclientverifyalias The Custom Header Field Names Only When `xforwardedforclientcertclientverifyenabled` Has a Value of True, this Value Will Not Take Effect until.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xforwardedforclientcertclientverifyenabled Indicates Whether the `X-Forwarded-Clientcert-clientverify` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate to Verify the Results.
 * @property xforwardedforclientcertfingerprintalias The Custom Header Field Names Only When `xforwardedforclientcertfingerprintenabled`, Which Evaluates to True When the Entry into Force of.The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xforwardedforclientcertfingerprintenabled Indicates Whether the `X-Forwarded-Clientcert-fingerprint` Header Field Is Used to Obtain Access to the Server Load Balancer Instance of the Client Certificate Fingerprint Value.
 * @property xforwardedforclientcertsubjectdnalias The name of the custom header. This parameter is valid only if `xforwardedforclientcertsubjectdnenabled` is set to true. The name must be 1 to 40 characters in length, and can contain letters, hyphens (-), underscores (_), and digits.
 * @property xforwardedforclientcertsubjectdnenabled Specifies whether to use the `X-Forwarded-Clientcert-subjectdn` header field to obtain information about the owner of the ALB client certificate. Valid values: true and false. Default value: false.
 * @property xforwardedforclientsrcportenabled Indicates Whether the X-Forwarded-Client-Port Header Field Is Used to Obtain Access to Server Load Balancer Instances to the Client, and Those of the Ports.
 * @property xforwardedforenabled Indicates whether the X-Forwarded-For header field is used to obtain the real IP address of tqhe client. Valid values: true and false. Default value: true.
 * @property xforwardedforprotoenabled Indicates Whether the X-Forwarded-Proto Header Field Is Used to Obtain the Server Load Balancer Instance Snooping Protocols.
 * @property xforwardedforslbidenabled Indicates whether the SLB-ID header field is used to obtain the ID of the ALB instance. Valid values: true and false. Default value: false.
 * @property xforwardedforslbportenabled Indicates Whether the X-Forwarded-Port Header Field Is Used to Obtain the Server Load Balancer Instance Listening Port.
 */
public data class GetListenersListenerXforwardedForConfig(
    public val xforwardedforclientcertIssuerdnalias: String,
    public val xforwardedforclientcertIssuerdnenabled: Boolean,
    public val xforwardedforclientcertclientverifyalias: String,
    public val xforwardedforclientcertclientverifyenabled: Boolean,
    public val xforwardedforclientcertfingerprintalias: String,
    public val xforwardedforclientcertfingerprintenabled: Boolean,
    public val xforwardedforclientcertsubjectdnalias: String,
    public val xforwardedforclientcertsubjectdnenabled: Boolean,
    public val xforwardedforclientsrcportenabled: Boolean,
    public val xforwardedforenabled: Boolean,
    public val xforwardedforprotoenabled: Boolean,
    public val xforwardedforslbidenabled: Boolean,
    public val xforwardedforslbportenabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersListenerXforwardedForConfig): GetListenersListenerXforwardedForConfig = GetListenersListenerXforwardedForConfig(
            xforwardedforclientcertIssuerdnalias = javaType.xforwardedforclientcertIssuerdnalias(),
            xforwardedforclientcertIssuerdnenabled = javaType.xforwardedforclientcertIssuerdnenabled(),
            xforwardedforclientcertclientverifyalias = javaType.xforwardedforclientcertclientverifyalias(),
            xforwardedforclientcertclientverifyenabled = javaType.xforwardedforclientcertclientverifyenabled(),
            xforwardedforclientcertfingerprintalias = javaType.xforwardedforclientcertfingerprintalias(),
            xforwardedforclientcertfingerprintenabled = javaType.xforwardedforclientcertfingerprintenabled(),
            xforwardedforclientcertsubjectdnalias = javaType.xforwardedforclientcertsubjectdnalias(),
            xforwardedforclientcertsubjectdnenabled = javaType.xforwardedforclientcertsubjectdnenabled(),
            xforwardedforclientsrcportenabled = javaType.xforwardedforclientsrcportenabled(),
            xforwardedforenabled = javaType.xforwardedforenabled(),
            xforwardedforprotoenabled = javaType.xforwardedforprotoenabled(),
            xforwardedforslbidenabled = javaType.xforwardedforslbidenabled(),
            xforwardedforslbportenabled = javaType.xforwardedforslbportenabled(),
        )
    }
}
