@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getListeners.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerIds
 * @property listenerProtocol
 * @property listeners
 * @property loadBalancerIds
 * @property outputFile
 * @property status
 */
public data class GetListenersResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val listenerIds: List<String>? = null,
    public val listenerProtocol: String? = null,
    public val listeners: List<GetListenersListener>,
    public val loadBalancerIds: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetListenersResult): GetListenersResult = GetListenersResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerIds = javaType.listenerIds().map({ args0 -> args0 }),
            listenerProtocol = javaType.listenerProtocol().map({ args0 -> args0 }).orElse(null),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetListenersListener.Companion.toKotlin(args0)
                })
            }),
            loadBalancerIds = javaType.loadBalancerIds().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
