@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property accessLogConfigs The Access Logging Configuration Structure.
 * @property addressAllocatedMode The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance
 * uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB
 * instance.
 * @property addressType The type of IP address that the ALB instance uses to provide services.
 * @property bandwidthPackageId The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a
 * public IP address.
 * @property createTime The creation time of the resource.
 * @property deletionProtectionConfigs Remove the Protection Configuration.
 * @property dnsName DNS Domain Name.
 * @property id The ID of the Load Balancer.
 * @property loadBalancerBillingConfigs The configuration of the billing method.
 * @property loadBalancerBusinessStatus Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`. **NOTE:** Available in 1.142.0+
 * @property loadBalancerBussinessStatus Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`.  **NOTE:** Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0.
 * @property loadBalancerEdition The edition of the ALB instance.
 * @property loadBalancerId The first ID of the resource.
 * @property loadBalancerName The name of the resource.
 * @property loadBalancerOperationLocks The Load Balancing Operations Lock Configuration.
 * @property modificationProtectionConfigs Modify the Protection Configuration.
 * @property resourceGroupId The ID of the resource group.
 * @property status The The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
 * @property tags The tag of the resource.
 * @property vpcId The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
 * @property zoneMappings The zones and vSwitches. You must specify at least two zones.
 */
public data class GetLoadBalancersBalancer(
    public val accessLogConfigs: List<GetLoadBalancersBalancerAccessLogConfig>,
    public val addressAllocatedMode: String,
    public val addressType: String,
    public val bandwidthPackageId: String,
    public val createTime: String,
    public val deletionProtectionConfigs: List<GetLoadBalancersBalancerDeletionProtectionConfig>,
    public val dnsName: String,
    public val id: String,
    public val loadBalancerBillingConfigs: List<GetLoadBalancersBalancerLoadBalancerBillingConfig>,
    public val loadBalancerBusinessStatus: String,
    @Deprecated(
        message = """
  Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it
      will be removed in the future version. Please use the new parameter
      'load_balancer_business_status' instead.
  """,
    )
    public val loadBalancerBussinessStatus: String,
    public val loadBalancerEdition: String,
    public val loadBalancerId: String,
    public val loadBalancerName: String,
    public val loadBalancerOperationLocks: List<GetLoadBalancersBalancerLoadBalancerOperationLock>,
    public val modificationProtectionConfigs: List<GetLoadBalancersBalancerModificationProtectionConfig>,
    public val resourceGroupId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val zoneMappings: List<GetLoadBalancersBalancerZoneMapping>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetLoadBalancersBalancer): GetLoadBalancersBalancer = GetLoadBalancersBalancer(
            accessLogConfigs = javaType.accessLogConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerAccessLogConfig.Companion.toKotlin(args0)
                })
            }),
            addressAllocatedMode = javaType.addressAllocatedMode(),
            addressType = javaType.addressType(),
            bandwidthPackageId = javaType.bandwidthPackageId(),
            createTime = javaType.createTime(),
            deletionProtectionConfigs = javaType.deletionProtectionConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerDeletionProtectionConfig.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName(),
            id = javaType.id(),
            loadBalancerBillingConfigs = javaType.loadBalancerBillingConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerLoadBalancerBillingConfig.Companion.toKotlin(args0)
                })
            }),
            loadBalancerBusinessStatus = javaType.loadBalancerBusinessStatus(),
            loadBalancerBussinessStatus = javaType.loadBalancerBussinessStatus(),
            loadBalancerEdition = javaType.loadBalancerEdition(),
            loadBalancerId = javaType.loadBalancerId(),
            loadBalancerName = javaType.loadBalancerName(),
            loadBalancerOperationLocks = javaType.loadBalancerOperationLocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerLoadBalancerOperationLock.Companion.toKotlin(args0)
                })
            }),
            modificationProtectionConfigs = javaType.modificationProtectionConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerModificationProtectionConfig.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            zoneMappings = javaType.zoneMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerZoneMapping.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
