@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property loadBalancerAddresses
 * @property vswitchId The ID of the vSwitch that corresponds to the zone. Each zone can use only one vSwitch and subnet.
 * @property zoneId The ID of the zone to which the ALB instance belongs.
 */
public data class GetLoadBalancersBalancerZoneMapping(
    public val loadBalancerAddresses: List<GetLoadBalancersBalancerZoneMappingLoadBalancerAddress>,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetLoadBalancersBalancerZoneMapping): GetLoadBalancersBalancerZoneMapping = GetLoadBalancersBalancerZoneMapping(
            loadBalancerAddresses = javaType.loadBalancerAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancerZoneMappingLoadBalancerAddress.Companion.toKotlin(args0)
                })
            }),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
