@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLoadBalancers.
 * @property addressType
 * @property balancers
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property loadBalancerBusinessStatus
 * @property loadBalancerBussinessStatus
 * @property loadBalancerIds
 * @property loadBalancerName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property resourceGroupId
 * @property status
 * @property tags
 * @property vpcId
 * @property vpcIds
 * @property zoneId
 */
public data class GetLoadBalancersResult(
    public val addressType: String? = null,
    public val balancers: List<GetLoadBalancersBalancer>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerBusinessStatus: String? = null,
    @Deprecated(
        message = """
  Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it
      will be removed in the future version. Please use the new attribute
      'load_balancer_business_status' instead.
  """,
    )
    public val loadBalancerBussinessStatus: String? = null,
    public val loadBalancerIds: List<String>? = null,
    public val loadBalancerName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vpcIds: List<String>? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetLoadBalancersResult): GetLoadBalancersResult = GetLoadBalancersResult(
            addressType = javaType.addressType().map({ args0 -> args0 }).orElse(null),
            balancers = javaType.balancers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersBalancer.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loadBalancerBusinessStatus = javaType.loadBalancerBusinessStatus().map({ args0 ->
                args0
            }).orElse(null),
            loadBalancerBussinessStatus = javaType.loadBalancerBussinessStatus().map({ args0 ->
                args0
            }).orElse(null),
            loadBalancerIds = javaType.loadBalancerIds().map({ args0 -> args0 }),
            loadBalancerName = javaType.loadBalancerName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vpcIds = javaType.vpcIds().map({ args0 -> args0 }),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
