@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerIds
 * @property loadBalancerIds
 * @property nameRegex
 * @property names A list of Rule names.
 * @property outputFile
 * @property ruleIds
 * @property rules A list of Alb Rules. Each element contains the following attributes:
 * @property status The status of the forwarding rule.
 */
public data class GetRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val listenerIds: List<String>? = null,
    public val loadBalancerIds: List<String>? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val ruleIds: List<String>? = null,
    public val rules: List<GetRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesResult): GetRulesResult =
            GetRulesResult(
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                listenerIds = javaType.listenerIds().map({ args0 -> args0 }),
                loadBalancerIds = javaType.loadBalancerIds().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                ruleIds = javaType.ruleIds().map({ args0 -> args0 }),
                rules = javaType.rules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRule.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
