@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The ID of the Rule.
 * @property listenerId The ID of the listener to which the forwarding rule belongs.
 * @property loadBalancerId The ID of the Application Load Balancer (ALB) instance to which the forwarding rule belongs.
 * @property priority The priority of the rule.
 * @property ruleActions The actions of the forwarding rules.
 * @property ruleConditions The conditions of the forwarding rule.
 * @property ruleId The ID of the Rule.
 * @property ruleName The name of the forwarding rule.
 * @property status The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
 */
public data class GetRulesRule(
    public val id: String,
    public val listenerId: String,
    public val loadBalancerId: String,
    public val priority: Int,
    public val ruleActions: List<GetRulesRuleRuleAction>,
    public val ruleConditions: List<GetRulesRuleRuleCondition>,
    public val ruleId: String,
    public val ruleName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesRule): GetRulesRule =
            GetRulesRule(
                id = javaType.id(),
                listenerId = javaType.listenerId(),
                loadBalancerId = javaType.loadBalancerId(),
                priority = javaType.priority(),
                ruleActions = javaType.ruleActions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleAction.Companion.toKotlin(args0)
                    })
                }),
                ruleConditions = javaType.ruleConditions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleCondition.Companion.toKotlin(args0)
                    })
                }),
                ruleId = javaType.ruleId(),
                ruleName = javaType.ruleName(),
                status = javaType.status(),
            )
    }
}
