@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fixedResponseConfigs The configuration of the fixed response.
 * @property forwardGroupConfigs The configurations of the destination server groups.
 * @property insertHeaderConfigs The configuration of the inserted header field.
 * @property order The order of the forwarding rule actions.
 * @property redirectConfigs The configuration of the external redirect action.
 * @property rewriteConfigs The redirect action within ALB.
 * @property trafficLimitConfigs The Flow speed limit.
 * @property trafficMirrorConfigs The Traffic mirroring.
 * @property type The type of the forwarding rule.
 */
public data class GetRulesRuleRuleAction(
    public val fixedResponseConfigs: List<GetRulesRuleRuleActionFixedResponseConfig>,
    public val forwardGroupConfigs: List<GetRulesRuleRuleActionForwardGroupConfig>,
    public val insertHeaderConfigs: List<GetRulesRuleRuleActionInsertHeaderConfig>,
    public val order: Int,
    public val redirectConfigs: List<GetRulesRuleRuleActionRedirectConfig>,
    public val rewriteConfigs: List<GetRulesRuleRuleActionRewriteConfig>,
    public val trafficLimitConfigs: List<GetRulesRuleRuleActionTrafficLimitConfig>,
    public val trafficMirrorConfigs: List<GetRulesRuleRuleActionTrafficMirrorConfig>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesRuleRuleAction): GetRulesRuleRuleAction = GetRulesRuleRuleAction(
            fixedResponseConfigs = javaType.fixedResponseConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionFixedResponseConfig.Companion.toKotlin(args0)
                })
            }),
            forwardGroupConfigs = javaType.forwardGroupConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionForwardGroupConfig.Companion.toKotlin(args0)
                })
            }),
            insertHeaderConfigs = javaType.insertHeaderConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionInsertHeaderConfig.Companion.toKotlin(args0)
                })
            }),
            order = javaType.order(),
            redirectConfigs = javaType.redirectConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionRedirectConfig.Companion.toKotlin(args0)
                })
            }),
            rewriteConfigs = javaType.rewriteConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionRewriteConfig.Companion.toKotlin(args0)
                })
            }),
            trafficLimitConfigs = javaType.trafficLimitConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionTrafficLimitConfig.Companion.toKotlin(args0)
                })
            }),
            trafficMirrorConfigs = javaType.trafficMirrorConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.alb.kotlin.outputs.GetRulesRuleRuleActionTrafficMirrorConfig.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
