@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property host The host name of the destination to which requests are redirected within ALB.
 * @property httpCode The redirect method.
 * @property path The path to which requests are to be redirected within ALB.
 * @property port The port of the destination to which requests are redirected.
 * @property protocol The protocol of the requests to be redirected.
 * @property query The query string of the request to be redirected within ALB.
 */
public data class GetRulesRuleRuleActionRedirectConfig(
    public val host: String,
    public val httpCode: String,
    public val path: String,
    public val port: String,
    public val protocol: String,
    public val query: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.alb.outputs.GetRulesRuleRuleActionRedirectConfig): GetRulesRuleRuleActionRedirectConfig = GetRulesRuleRuleActionRedirectConfig(
            host = javaType.host(),
            httpCode = javaType.httpCode(),
            path = javaType.path(),
            port = javaType.port(),
            protocol = javaType.protocol(),
            query = javaType.query(),
        )
    }
}
